/*
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Feb 15, 2003
 * Time: 1:22:04 PM
 */
package math;

import futils.WriterUtil;

public class MathUtils {
    public static double LOG2 = Math.log(2);


    public static void writeOutRandomNumbersToAFile() {
        int ia[] = new int[100];
        for (int i = 0; i < ia.length; i++)
            ia[i] = Random.rand(1, 100);
        WriterUtil.writeString(WriterUtil.getCSVString(ia));
    }

    public static boolean odd(int i) {
        if ((i & 1) == 1) return true;
        return false;
    }

    /**
     * @param d input argument to the log2 function
     * @return base 2 log.
     */
    public static int getLogBase2(double d) {
        return (int) (Math.log(d) / Math.log(2));
    }

    public static double getGauss(double x,
                                  double xc, double sigma) {
        double oneOnSigmaSquaredOn2 = 1 / (sigma * sigma) / 2;
        return
                Math.exp(-((x - xc) * (x - xc)) *
                        oneOnSigmaSquaredOn2) / Math.PI * oneOnSigmaSquaredOn2;
    }

    public static double[] getGauss(int n) {
        double g[] = new double[n];
        for (int x = 0; x < n; x++)
            g[x] = getGauss(x, n / 2, 2);
        return g;
    }

    public static void testGauss() {
        print(getGauss(10));
    }

    /**
     * @noinspection FinalStaticMethod
     */
    public static final void print(double d[]) {
        for (int i = 0; i < d.length; i++)
            System.out.println(d[i]);
    }

    public static void testLongIsqrt() {
        int max = Short.MAX_VALUE;
        for (short i = 0; i < max; i++)
            if (isqrt(i) != (short) Math.sqrt(i))
                System.out.println("error at" + i);
        System.out.println("done at i=" + max + "sqrt=" + isqrt(max));
    }

    public static short isqrt(short x) {

        short x1;

        short s, g0, g1;

        if (x <= 1) return x;

        s = 1;

        x1 = (short) (x - 1);

        if (x1 > 65535) {
            s = (short) (s + 8);
            x1 = (short) (x1 >> 16);
        }

        if (x1 > 255) {
            s = (short) (s + 4);
            x1 = (short) (x1 >> 8);
        }

        if (x1 > 15) {
            s = (short) (s + 2);
            x1 = (short) (x1 >> 4);
        }

        if (x1 > 3) {
            s = (short) (s + 1);
        }
        g0 = (short) (1 << s); // g0 = 2**s.
        g1 = (short) ((g0 + (x >> s)) >> 1); //g1 = (g0 + x/g0)/2.

        while (g1 < g0) {

            g0 = g1;

            g1 = (short) ((g0 + (x / g0)) >> 1);

        }

        return g0;

    }


    public static int isqrt(int x) {

        int x1;

        int s, g0, g1;

        if (x <= 1) return x;

        s = 1;

        x1 = x - 1;

        if (x1 > 65535) {
            s = s + 8;
            x1 = x1 >> 16;
        }

        if (x1 > 255) {
            s = s + 4;
            x1 = x1 >> 8;
        }

        if (x1 > 15) {
            s = s + 2;
            x1 = x1 >> 4;
        }

        if (x1 > 3) {
            s = s + 1;
        }

        g0 = 1 << s; // g0 = 2**s.

        g1 = (g0 + (x >> s)) >> 1; //g1 = (g0 + x/g0)/2.

        while (g1 < g0) {

            g0 = g1;

            g1 = (g0 + (x / g0)) >> 1;

        }

        return g0;

    }

    public static int roundToIntegralPowerOf2(int n) {
        return 1 << log2(n); // length = 2**nu
    }

    public static int gcd(int a, int b) {
        if (b == 0) return a;
        return gcd(b, a % b);
    }

    public static int log2(int l) {
        return (int) (Math.log(l) / LOG2);
    }

    public static double getLOG2() {
        return LOG2;
    }

    public static double log2(double l) {
        return Math.log(l) / LOG2;
    }

    public static boolean isPowerOfTwo(double l) {
        return log2(l) == log2((int) l);
    }


}
