package j3d.utils.propertyEditors;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.lang.reflect.Method;


public class PESliderBuilder extends PropertyEditorBuilder {

    protected JSlider slider;

    private static Dimension preferredSizeHor = new Dimension(200, 50);
    private static Dimension preferredSizeVer = new Dimension(60, 100);

    public PESliderBuilder(int orientation, int low, int high, Object obj,
                           String name, boolean timer) {
        this(orientation, low, high, majorTickIncr(low, high), obj, name, timer);
    }

    public PESliderBuilder(int orientation, int low, int high,
                           int majorTickIncr, Object obj, String name, boolean timer) {
        this(orientation, low, high, majorTickIncr, majorTickIncr / 10, obj, name, timer);
    }

    public PESliderBuilder(int orientation, int low, int high,
                           int majorTickIncr, int minorTickIncr,
                           Object obj, String name, boolean timer) {
        slider = new JSlider(low, high);
        slider.setOrientation(orientation);
        slider.setPreferredSize(orientation == JSlider.HORIZONTAL ? preferredSizeHor :
                preferredSizeVer);
        slider.setMajorTickSpacing(majorTickIncr);
        slider.setMinorTickSpacing(minorTickIncr);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks((double) minorTickIncr / (high - low) < 0.02);
        init(obj, name, timer);
    }

    public void addEventListener(final Object obj, final Method writer) {
        slider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                writeToObject(obj, writer, new Double(slider.getValue()));
            }
        });
    }

    public JComponent getSwingJComponent() {
        return slider;
    }

    /**
     * The majorTickIncrement is some integer power of 10.  We want 10^power
     * to be less than high.
     */
    private static int majorTickIncr(int low, int high) {
        int range = high - low;
        int estimate =
                (int) Math.max(1,
                        Math.pow(10,
                                (int) Math.round(Math.log(range) / Math.log(10)) - 1));
        while (range / estimate >= 10) estimate++;
        return estimate;
    }

    public void setSwingJComponentFromObject(Object obj, Method reader) {
        if (!slider.getValueIsAdjusting())
            slider.setValue(((Double) readFromObject(obj, reader)).intValue());
    }

}