package j3d.utils;


import j3d.polyViewer.vec3.Vec3;

import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class PolyhedralShape3d extends javax.media.j3d.Shape3D {
    public PolyhedralShape3d(Vec3[][] triList, Appearance app) {

        TriangleArray ta = new TriangleArray(3 * triList.length,
                GeometryArray.COORDINATES | GeometryArray.NORMALS);

        for (int i = 0; i < triList.length; i++) {
            // for each given triangle
            Vec3 v0 = triList[i][0];
            // extract vertices
            Vec3 v1 = triList[i][1];
            Vec3 v2 = triList[i][2];

            // compute outward normal for lighting calculations
            Vec3 norm = Vec3.unit(Vec3.cross(Vec3.minus(v1, v0),
                    Vec3.minus(v2, v0)));

            // convert points and normals to vecmath format
            ta.setCoordinate(3 * i + 0, new Point3f(v0.x, v0.y, v0.z));
            ta.setNormal(3 * i + 0, new Vector3f(norm.x,
                    norm.y,
                    norm.z));
            ta.setCoordinate(3 * i + 1, new Point3f(v1.x, v1.y, v1.z));
            ta.setNormal(3 * i + 1, new Vector3f(norm.x,
                    norm.y,
                    norm.z));
            ta.setCoordinate(3 * i + 2, new Point3f(v2.x, v2.y, v2.z));
            ta.setNormal(3 * i + 2, new Vector3f(norm.x,
                    norm.y,
                    norm.z));
        }
        //Make it so you can see both sides of the triangles:
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(PolygonAttributes.CULL_NONE);
        app.setPolygonAttributes(pa);

        this.setGeometry(ta);
        // put triangles in this object
        this.setAppearance(app);
        // pass along given appearance
        //this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        // // allow rotation
    }

}