package j3d.utils;

/*
      @(#)MaterialEditor.java 1.2 01/08/01 11:02:20

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.layouts.LeftAlignComponent;
import gui.run.FloatEvent;
import gui.run.FloatLabelJSlider;
import gui.run.FloatListener;

import javax.media.j3d.Material;
import javax.swing.*;
import javax.vecmath.Color3f;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class MaterialEditor extends Box implements
        Java3DExplorerConstants {

    Material material;
    boolean lightingEnable;
    Color3f ambientColor = new Color3f();
    Color3f diffuseColor = new Color3f();
    Color3f emissiveColor = new Color3f();
    Color3f specularColor = new Color3f();
    float shininess;
    JCheckBox lightingEnableCheckBox;
    Color3fEditor ambientEditor;
    Color3fEditor diffuseEditor;
    Color3fEditor emissiveEditor;
    Color3fEditor specularEditor;
    FloatLabelJSlider shininessSlider;

    public MaterialEditor(Material init) {
        super(BoxLayout.Y_AXIS);
        material = init;
        lightingEnable = material.getLightingEnable();
        material.getAmbientColor(ambientColor);
        material.getDiffuseColor(diffuseColor);
        material.getEmissiveColor(emissiveColor);
        material.getSpecularColor(specularColor);
        shininess = material.getShininess();

        lightingEnableCheckBox = new JCheckBox("Lighting Enable", lightingEnable);
        lightingEnableCheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                lightingEnable = checkbox.isSelected();
                material.setLightingEnable(lightingEnable);
            }
        });
        // add the checkbox to the panel
        add(new LeftAlignComponent(lightingEnableCheckBox));

        ambientEditor = new Color3fEditor("Ambient Color  ", ambientColor);
        ambientEditor.addColor3fListener(new Color3fListener() {
            public void colorChanged(Color3fEvent event) {
                event.getValue(ambientColor);
                material.setAmbientColor(ambientColor);
            }
        });
        add(ambientEditor);

        diffuseEditor = new Color3fEditor("Diffuse Color    ", diffuseColor);
        diffuseEditor.addColor3fListener(new Color3fListener() {
            public void colorChanged(Color3fEvent event) {
                event.getValue(diffuseColor);
                material.setDiffuseColor(diffuseColor);
            }
        });
        add(diffuseEditor);

        emissiveEditor = new Color3fEditor("Emissive Color", emissiveColor);
        emissiveEditor.addColor3fListener(new Color3fListener() {
            public void colorChanged(Color3fEvent event) {
                event.getValue(emissiveColor);
                material.setEmissiveColor(emissiveColor);
            }
        });
        add(emissiveEditor);

        specularEditor = new Color3fEditor("Specular Color ", specularColor);
        specularEditor.addColor3fListener(new Color3fListener() {
            public void colorChanged(Color3fEvent event) {
                event.getValue(specularColor);
                material.setSpecularColor(specularColor);
            }
        });
        add(specularEditor);

        shininessSlider = new FloatLabelJSlider("Shininess: ", 1.0f, 0.0f, 128.0f, shininess);
        shininessSlider.setMajorTickSpacing(16.0f);
        shininessSlider.setPaintTicks(true);
        shininessSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                shininess = e.getValue();
                material.setShininess(shininess);
            }
        });
        add(shininessSlider);
    }
}
