package j3d.utils;

/*
      @(#)LineAttributesEditor.java 1.2 01/08/01 11:02:19

***************************************************************
"Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

-Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

-Redistribution in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

Neither the name of Sun Microsystems, Inc. or the names of contributors may be
used to endorse or promote products derived from this software without
specific prior written permission.

This software is provided "AS IS," without a warranty of any kind. ALL
EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY
IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE
LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN OR ITS
LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,
INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER
CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF
OR INABILITY TO USE SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

You acknowledge that Software is not designed,licensed or intended for use in
the design, construction, operation or maintenance of any nuclear facility."

****************************************************************************
*/

import gui.run.*;

import javax.media.j3d.LineAttributes;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


public class LineAttributesEditor extends Box
        implements Java3DExplorerConstants {

    // LineAttributes
    LineAttributes lineAttr;
    float lineWidth;
    int linePattern;
    boolean lineAAEnable;

    public LineAttributesEditor(LineAttributes init) {
        super(BoxLayout.Y_AXIS);
        lineAttr = init;
        lineWidth = lineAttr.getLineWidth();
        linePattern = lineAttr.getLinePattern();
        lineAAEnable = lineAttr.getLineAntialiasingEnable();

        FloatLabelJSlider lineWidthSlider =
                new FloatLabelJSlider("Width", 0.1f, 0.0f, 5.0f, lineWidth);
        lineWidthSlider.setMajorTickSpacing(1.0f);
        lineWidthSlider.setPaintTicks(true);
        lineWidthSlider.addFloatListener(new FloatListener() {
            public void floatChanged(FloatEvent e) {
                lineWidth = e.getValue();
                lineAttr.setLineWidth(lineWidth);
            }
        });
        lineWidthSlider.setAlignmentX(Component.LEFT_ALIGNMENT);
        add(lineWidthSlider);

        String[] patternNames = {
            "PATTERN_SOLID",
            "PATTERN_DASH",
            "PATTERN_DOT",
            "PATTERN_DASH_DOT"
        };
        int[] patternValues = {
            LineAttributes.PATTERN_SOLID,
            LineAttributes.PATTERN_DASH,
            LineAttributes.PATTERN_DOT,
            LineAttributes.PATTERN_DASH_DOT
        };

        IntChooser patternChooser = new IntChooser("Pattern:",
                patternNames, patternValues, linePattern);
        patternChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                lineAttr.setLinePattern(value);
            }
        });
        patternChooser.setAlignmentX(Component.LEFT_ALIGNMENT);
        add(patternChooser);

        JCheckBox lineAACheckBox = new JCheckBox(antiAliasString);
        lineAACheckBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox) e.getSource();
                lineAAEnable = checkbox.isSelected();
                lineAttr.setLineAntialiasingEnable(lineAAEnable);
            }
        });
        lineAACheckBox.setAlignmentX(Component.LEFT_ALIGNMENT);
        // add the checkbox to the panel
        add(lineAACheckBox);
    }
}
