package j3d.utils;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import gui.run.IntChooser;
import gui.run.IntEvent;
import gui.run.IntListener;
import utils.ResourceManager;

import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Switch;
import java.io.File;


public class BackgroundTool implements Java3DExplorerConstants {

    Switch bgSwitch;
    IntChooser bgChooser;

    public BackgroundTool() {

        bgSwitch = new Switch(Switch.CHILD_NONE);
        bgSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);

        // set up the dark grey BG color node
        Background bgDarkGrey = new Background(darkGrey);
        bgDarkGrey.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgDarkGrey);

        // set up the grey BG color node
        Background bgGrey = new Background(grey);
        bgGrey.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgGrey);

        // set up the light grey BG color node
        Background bgLightGrey = new Background(lightGrey);
        bgLightGrey.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgLightGrey);

        // set up the white BG color node
        Background bgWhite = new Background(white);
        bgWhite.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgWhite);

        // set up the blue BG color node
        Background bgBlue = new Background(skyBlue);
        bgBlue.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgBlue);

        // set up the image
        java.net.URL bgImageURL = null;
        ResourceManager rm = ResourceManager.getResourceManager();
        File f = rm.getImageFile("bg.jpg");
        try {
            bgImageURL = f.toURL();
        } catch (java.net.MalformedURLException ex) {
            System.out.println(ex.getMessage());
            System.exit(1);
        }
        if (bgImageURL == null) { // application, try file URL
            try {
                bgImageURL = new java.net.URL("file:./bg.jpg");
            } catch (java.net.MalformedURLException ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
        }
        TextureLoader bgTexture = new TextureLoader(bgImageURL, null);

        // Create a background with the static image
        Background bgImage = new Background(bgTexture.getImage());
        bgImage.setApplicationBounds(infiniteBounds);
        bgSwitch.addChild(bgImage);

        // create a background with the image mapped onto a sphere which
        // will enclose the world
        Background bgGeo = new Background();
        bgGeo.setApplicationBounds(infiniteBounds);
        BranchGroup bgGeoBG = new BranchGroup();
        Appearance bgGeoApp = new Appearance();
        bgGeoApp.setTexture(bgTexture.getTexture());
        Sphere sphereObj = new Sphere(1.0f,
                Sphere.GENERATE_NORMALS |
                Sphere.GENERATE_NORMALS_INWARD |
                Sphere.GENERATE_TEXTURE_COORDS,
                45, bgGeoApp);
        bgGeoBG.addChild(sphereObj);
        bgGeo.setGeometry(bgGeoBG);
        bgSwitch.addChild(bgGeo);


        // Create the chooser GUI
        String[] bgNames = {
            "No Background (Black)",
            "Dark Grey",
            "Grey",
            "Light Grey",
            "White",
            "Blue",
            "Sky Image",
            "Sky Geometry",
        };
        int[] bgValues = {Switch.CHILD_NONE, 0, 1, 2, 3, 4, 5, 6};

        bgChooser = new IntChooser("Background:", bgNames,
                bgValues, 0);
        bgChooser.addIntListener(new IntListener() {
            public void intChanged(IntEvent event) {
                int value = event.getValue();
                bgSwitch.setWhichChild(value);
            }
        });
        bgChooser.setValue(Switch.CHILD_NONE);
    }

    public Switch getSwitch() {
        return bgSwitch;
    }

    public IntChooser getChooser() {
        return bgChooser;
    }

}
