/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j3d.polyViewer.vec3;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 2, 2005
 * <p/>
 * Time: 4:02:56 AM
 */
public class CylindricalSpiral
        implements Vec3FunctionInterface {
    double sqrt_2 = Math.sqrt(2);

    public CylindricalSpiral() {

    }

    // uu ranges from 0 to 2*PI, but want -PI/4...3*PI/2
    double umin = -Math.PI / 4;
    double umax = 3 * Math.PI / 2;
    double twoPi = 2 * Math.PI;

    public Vec3 getPolarVec3(double a,
                             double u,
                             double b,
                             double v) {
        //a ranges from 0 to 1. want it to range from
        //b ranges from 0 to .5.
        //u, v range from 0 to 2PI


        double x, y, z;
        double n = 3;
        double c = 0.5;
        x = a*cos(n*v)*(1+cos(u)+c*cos(n*v));


        y = a * sin(n * v) * (1 + cos(u) + c * sin(n * v));


        z = b*v/twoPi + a*sin(u);

        return new Vec3((float) x,
                (float) y,
                (float) z);
    }

    public static final double sin(double theta) {
        return Math.sin(theta);
    }

    public static final double cos(double theta) {
        return Math.cos(theta);
    }

    public String toString() {
        return getClass().getName();
    }
}
