package j3d.examples.text;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import java.applet.Applet;
import java.awt.*;


public class Text2DApp extends Applet {

    public BranchGroup createSceneGraph() {
        BranchGroup branchGroupRoot
                = new BranchGroup();
        TransformGroup tg
                = new TransformGroup();
        tg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        branchGroupRoot.addChild(tg);
        Text2D text2d
                = new Text2D("2D text in Java 3D",
                        new Color3f(0.9f, 1.0f, 1.0f),
                        "Helvetica", 24, Font.ITALIC);
        tg.addChild(text2d);

        makeText2Sided(text2d.getAppearance());

        // Create a new Behavior object that will perform the desired
        // operation on the specified transform object and add it into
        // the scene graph.
        Alpha rotationAlpha = new Alpha(-1, 8000);

        RotationInterpolator ri =
                new RotationInterpolator(rotationAlpha, tg);
        boundingSphereAtOriginR100(ri, tg);

        Background bkRound = new Background();
        bkRound.setColor(0.4f, 0.4f, 1.0f);
        bkRound.setApplicationBounds(new BoundingSphere());
        branchGroupRoot.addChild(bkRound);

        return branchGroupRoot;
    } // end of CreateSceneGraph method

    private void makeText2Sided(Appearance textAppear) {
        PolygonAttributes polyAttrib = new PolygonAttributes();
        polyAttrib.setCullFace(PolygonAttributes.CULL_NONE);
        polyAttrib.setBackFaceNormalFlip(true);
        textAppear.setPolygonAttributes(polyAttrib);
    }

    private void boundingSphereAtOriginR100(RotationInterpolator ri,
                                            TransformGroup tg) {
        BoundingSphere bs = new BoundingSphere();
        ri.setSchedulingBounds(bs);
        tg.addChild(ri);
    }


    public Text2DApp() {
        setLayout(new BorderLayout());
        GraphicsConfiguration gc =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D canvas3D = new Canvas3D(gc);
        canvas3D.setStereoEnable(false);
        add("Center", canvas3D);

        BranchGroup bg = createSceneGraph();
        SimpleUniverse su = new SimpleUniverse(canvas3D);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(bg);
    }

    public static void main(String[] args) {
        new MainFrame(new Text2DApp(), 256, 32);
    } // end of main (method of Text2DApp)

} // end of class Text2DApp
