package j3d.examples.shape.triangles.surfaces.geometries;

import j3d.examples.shape.triangles.surfaces.SurfaceGeometry;
import j3d.examples.shape.triangles.surfaces.SurfaceUniverse;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;
import java.awt.*;

public class Moebius extends SurfaceGeometry {

    public Moebius(int strips, int stripLength, Color3f c1, Color3f c2) {
        super(strips, stripLength, c1, c2);
    }

    public Vector3d getViewingPosition() {
        return new Vector3d(0, 0, 2);
    }

    public static void main(String[] args) {
        new SurfaceUniverse("Moebius",
                new Moebius(5, 100, new Color3f(Color.cyan), new Color3f(Color.blue)));
    }

    public double x(int strip, int index, int segment) {
        double a = radians(index * 2);
        return 0.7 * Math.sin(a) + 0.2 * Math.cos(a) * (segment * 2 - 1);
    }

    public double y(int strip, int index, int segment) {
        double a = radians(index * 2);
        return 0.3 * Math.sin(a) * (segment * 2 - 1);
    }

    public double z(int strip, int index, int segment) {
        double a = radians(index * 2);
        return 0.7 * Math.cos(a) + 0.2 * Math.cos(a) * (segment * 2 - 1);
    }

}