package j3d.examples.shape.cube;


import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import java.applet.Applet;
import java.awt.*;

//   HelloJava3Da renders a single, rotating cube.

public class StillCube extends Applet {
    public StillCube() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();

        Canvas3D c3d = new Canvas3D(config);
        add("Center", c3d);

        BranchGroup bg = getBranchGroup();

        // SimpleUniverse is a Convenience Utility class
        SimpleUniverse su = new SimpleUniverse(c3d);

        // This will move the ViewPlatform back a bit so the
        // objects in the scene can be viewed.
        su.getViewingPlatform().setNominalViewingTransform();

        su.addBranchGraph(bg);
    } // end of HelloJava3Da (constructor)

    public BranchGroup getBranchGroup() {
        // Create the root of the branch graph
        BranchGroup bg = new BranchGroup();

        bg.addChild(new ColorCube(.5));
        bg.compile();

        return bg;
    } // end of CreateSceneGraph method of HelloJava3Da

    //  The following allows this to be run as an application
    //  as well as an applet

    public static void main(String[] args) {
        new MainFrame(new StillCube(), 256, 256);
    }

} // end of class HelloJava3Da
