/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.shapes;

import javax.media.j3d.*;

/*
 * An invisible shape for use with influences such as EmitShapeLight.
 */
public class Phantom extends Shape3D {

	public Phantom() {
		setGeometry(createGeometry());
		setAppearance(createAppearance());
	}

	protected Appearance createAppearance() {
		Appearance appearance = new Appearance();
		TransparencyAttributes ta = new TransparencyAttributes();
		ta.setTransparency(1);
		ta.setTransparencyMode(TransparencyAttributes.NICEST);
		appearance.setTransparencyAttributes(ta);
		return appearance;
	}
	
	private Geometry createGeometry() {
		PointArray geometry = new PointArray(1, getVertexFormat());
		float[] coordinates = new float[3];
		coordinates[0] = 0;
		coordinates[1] = 0;
		coordinates[2] = 0;

		geometry.setCoordinates(0, coordinates);
		return geometry;
	}

	protected int getVertexFormat() {
		return GeometryArray.COORDINATES;
	}
}
