/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;
import j3d.examples.particles.*;
import j3d.examples.particles.emitters.*;
import javax.media.j3d.*;

public class Shape3DInfluence {
	
	protected void allowChangeAppearance(Shape3D aShape) {
		aShape.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		aShape.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
	}
	
	protected void allowChangeTransparency(Shape3D aShape) {
		allowChangeAppearance(aShape);
		Appearance anAppearance = getAppearance(aShape);
		anAppearance.setCapability(
			Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_READ);
		anAppearance.setCapability(
			Appearance.ALLOW_TRANSPARENCY_ATTRIBUTES_WRITE);

		TransparencyAttributes ta = anAppearance.getTransparencyAttributes();
		if (ta == null) {
			ta = new TransparencyAttributes();
			anAppearance.setTransparencyAttributes(ta);
		}

		ta.setCapability(TransparencyAttributes.ALLOW_VALUE_WRITE);
		ta.setTransparencyMode(TransparencyAttributes.NICEST);
	}
	
	protected void allowReadCollisionBounds(Shape3D aShape){
		aShape.setCapability(Shape3D.ALLOW_COLLISION_BOUNDS_READ);
	}
	
	protected void allowReadLocalToWorld(Shape3D aShape){
		aShape.setCapability(Shape3D.ALLOW_LOCAL_TO_VWORLD_READ);
	}

	protected Appearance getAppearance(Shape3D aShape) {
		Appearance anAppearance = aShape.getAppearance();
		if (anAppearance == null) {
			anAppearance = new Appearance();
			aShape.setAppearance(anAppearance);
		}
		return anAppearance;
	}
	
	protected Shape3D getShape3D(Particle aParticle){
		Shape3DParticleSystem shapeParticleSystem = (Shape3DParticleSystem) aParticle.getEmitter().getParticleSystem();
		Shape3D aShape = shapeParticleSystem.getShape(aParticle);
		return aShape;
	}
	
	protected BranchGroup getBranchGroup(Particle aParticle){
		Shape3DParticleSystem sps = (Shape3DParticleSystem) aParticle.getEmitter().getParticleSystem();
		return sps.getBranchGroup(aParticle);
	}
	
	protected Transform3D getLocalToWorld(Particle aParticle){
		Shape3DParticleSystem shapeParticleSystem = (Shape3DParticleSystem) aParticle.getEmitter().getParticleSystem();
		Shape3D aShape = shapeParticleSystem.getShape(aParticle);
		Transform3D t3d = new Transform3D();
		aShape.getLocalToVworld(t3d);
		return t3d;
	}
	
	protected boolean isCompatible(Particle aParticle){
		// TODO: Graceful error reporting when an influence is not compatible with a particle system
		IParticleSystem ps = aParticle.getEmitter().getParticleSystem();
		// Guard against accidental use with non-shape particle systems
		return (ps instanceof Shape3DParticleSystem);
	}
}
