/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import j3d.examples.particles.emitters.Particle;

//TODO: Need ChangeColor influence
//TODO: Need ChangeShapeColor? influence
//TODO: Need Wind influence
//TODO: Consider adding Bounds to all influences
//TODO: Consider allowing influences to age and change with age

public interface IExternalInfluence {
	
	/**
	 * Initialize a particle prior to the first emission.
	 * @param aParticle - the particle to initialize.
	 */
	public void initializeParticle(Particle aParticle);
	
	/**
	 * Apply this (possibly time varying) influence 
	 * to the particle for the time interval.
	 * @param aParticle - The particle to update
	 * @param dt - The time interval (in seconds) since the last apply
	 */
	public void apply(Particle aParticle, float dt);
}
