/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import j3d.examples.particles.emitters.Particle;
import javax.media.j3d.*;

public class DebugShape
	extends Shape3DInfluence
	implements IExternalInfluence {

	public void initializeParticle(Particle aParticle) {
		if (isCompatible(aParticle)) {
			if (aParticle.getIndice() != 0) {
				Shape3D aShape = getShape3D(aParticle);
				allowChangeTransparency(aShape);
				Appearance a = aShape.getAppearance();
				TransparencyAttributes ta = a.getTransparencyAttributes();
				ta.setTransparency(0.7f);
			}

		}
	}

	public void apply(Particle aParticle, float dt) {
		// everything happens when initializing.
	}

}
