/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.influences;

import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import j3d.examples.particles.emitters.*;

/**
 * Scales the particle if it is within the 
 * bounds of the influence.
 */
public class BoundedScale implements IExternalInfluence, IParticleLifeCycleListener {
	private float scale;
	private float base;
	private BoundingSphere bounds;
	private Point3d location;  // to avoid object creation
	private Point3d center;
	private float radius;
	
	public BoundedScale(float aBase, float aScale, BoundingSphere aBounds) {
		scale = aScale;
		base = aBase;
		bounds = aBounds;
		location = new Point3d();
		center = new Point3d();
		aBounds.getCenter(center);
		radius = (float)aBounds.getRadius();
	}
	
	public void initializeParticle(Particle aParticle){
		// Nothing to do
	}
	
	public void apply(Particle aParticle, float dt) {
		float [] world = aParticle.getWorldPosition();
		location.x = (double) world[0];
		location.y = (double) world[1];
		location.z = (double) world[2];
		boolean intersect = bounds.intersect(location);
		if(!intersect){
			// bounded but not within bounds
			return;
		}
		
		float distance = (float) center.distance(location);
		float newSize = Math.max(base + scale * ((radius - distance)/radius), 0.01f);
		aParticle.setScale(newSize);
	}

	public void aboutToDie(List c, float dt) {
		// Nothing to do
	}

	public void aboutToEmit(List aList, float dt) {
		int aSize = aList.size();
		for(int i = 0; i < aSize; i++){	
			Particle aParticle = (Particle)aList.get(i);
			aParticle.setScale(Math.max(base, 0.01f));
		}
	}

	public void updated(List c, float dt) {
		//  Nothing to do
	}


}
