/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.generationshapes;
import j3d.examples.particles.emitters.*;

import javax.vecmath.*;
/**
 * Emits particles from within a circle or disk.  Particles are emitted
 * from a region defined by the local origin, the radius and radius 
 * variance.  A small radius variance emits from a ring.  A radius
 * variance equal to the radius emits from a circle.  The particles are 
 * emitted along the plane of the circle or disk.  
 */

public class RadialGenerationShape
	extends GenerationShape
	implements IGenerationShape {
		
	private float radius;
	private float radiusVariance;

	public RadialGenerationShape(float aRadius, float aRadiusVariance) {
		radius = aRadius;
		radiusVariance = aRadiusVariance;
	}
	
	protected float getVaryingRadius() {
		return radius + random() * radiusVariance;
	}
	
	public void initializeParticlePosition(Particle aParticle){
		// Reset to a location within the ring defined by the
		// local origin, the radius, and radius variation.
		float thisRadius = getVaryingRadius();
		double radians = random()* Math.PI;
		double x = thisRadius * Math.cos(radians);
		double z = thisRadius * Math.sin(radians);
		aParticle.setInitialLocalPosition((float)x, 0f, (float)z);
	}
	
	public void initializeParticleVelocity(Particle aParticle) {
		Vector3f velocity = new Vector3f();
		float [] position = aParticle.getLocalPosition();
		float magnitude = getVaryingParticleVelocity();
		velocity.set(position[0],0,position[2]);
		velocity.normalize();
		velocity.scale(magnitude);			
		aParticle.setLocalVelocity(velocity);
	}

}
