/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.GraphicsConfiguration;

import javax.media.j3d.*;
import javax.vecmath.*;

import j3d.examples.particles.*;
import j3d.examples.particles.emitters.*;
import j3d.examples.particles.generationshapes.*;
import j3d.examples.particles.influences.*;
import j3d.examples.particles.shapes.*;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;
public class FlamesExample extends Applet {
	
	public static void main(String[] args) {
		new MainFrame(new FlamesExample(false), 600, 600);
	}
	private Canvas3D canvas3D;
	private boolean recording;
	
	public FlamesExample(boolean isRecording) {
		initialize(isRecording);
	}
	
	public BranchGroup createSceneGraph(SimpleUniverse su) {
		BranchGroup objRoot = new BranchGroup();
		
		XZPlane plane = new XZPlane(1, 50, true, new Color3f(0.0f,0.0f,0.0f));
		objRoot.addChild(plane);

		BoundingSphere bounds = new BoundingSphere();
		bounds.setRadius(300);
		// Add a behavior to measure frame rates
		FrameRateBehavior fps = new FrameRateBehavior();
		fps.setSchedulingBounds(bounds);
		objRoot.addChild(fps);
		
		ParticleEmitter flamesEmitter =  new ParticleEmitter(
						new DiskGenerationShape(0, 1, 1),
						25f, 	// emission rate 30
						0f, 	// emission rate variance
						8f, 	// velocity
						2f, 	// velocity variance
						0.7f, 	// lifetime 0.8
						0.5f,	// lifetime variance
						1500	// emitter lifetime in seconds
						);
		
		flamesEmitter.addInfluence(new FadeShape(new ParticleAgeAlpha(0,0,0.1f,0.9f)));
		flamesEmitter.addInfluence(new Scale(1,1, new ParticleAgeAlpha(0,0,0.4f,0.6f)));
		
		IShape3DFactory flamesFactory = new CloudPuffFactory(2f, 1f, new Color3f(0.65f, 0f, 0f), new Color3f(0.2f, 0.3f, 0f), 6, 1, CloudPuff.FLAMES);		
		Shape3DParticleSystem flames = new Shape3DParticleSystem(flamesEmitter, flamesFactory);
		
		TransformGroup flamesGroup = new TransformGroup();
		Transform3D flamesT3d = new Transform3D();
		flamesT3d.setTranslation(new Vector3f(0, 1, 0));
		flamesGroup.setTransform(flamesT3d);
		flamesGroup.addChild(flames);
		objRoot.addChild(flamesGroup);
		
		ParticleEmitter lightEmitter =  new ParticleEmitter(
						new DiskGenerationShape(0, 1.5f, 1.5f),
						1.5f, 	// emission rate
						0.5f, 	// emission rate variance
						0f, 	// velocity
						0f, 	// velocity variance
						4f, 	// lifetime
						2f,		// lifetime variance
						1500	// emitter lifetime in seconds
						);

		lightEmitter.addInfluence(new EmitShapeLight(new Color3f(0.8f, 0.4f, 0f),1,0,2));
		
		IShape3DFactory lightFactory = new PhantomFactory(10, 3);			
		Shape3DParticleSystem lights = new Shape3DParticleSystem(lightEmitter, lightFactory);
		
		TransformGroup lightGroup = new TransformGroup();
		Transform3D lightT3d = new Transform3D();
		lightT3d.setTranslation(new Vector3f(0, 3f, 0));
		lightGroup.setTransform(lightT3d);
		lightGroup.addChild(lights);
		objRoot.addChild(lightGroup);
		
		AmbientLight ambient = new AmbientLight();
		ambient.setColor(new Color3f(1f, 1f, 1f));
		ambient.setInfluencingBounds(bounds);
		objRoot.addChild(ambient);

		// Add a directional light
		DirectionalLight directional = new DirectionalLight();
		directional.setDirection(1.0f, -0.4f, 1f);
		directional.setColor(new Color3f(1f, 1f, 1f));
		directional.setInfluencingBounds(bounds);
		objRoot.addChild(directional);		

		// Add a behavior to manage the particle system animation
		ParticleSystemManager manager = ParticleSystemManager.getCurrent();
		manager.setSchedulingBounds(bounds);
		objRoot.addChild(manager);
		
		// Add an image capturing behavior
		if(recording){
			ImageCaptureBehavior capture = new ImageCaptureBehavior(canvas3D, 0, 300);
			capture.setSchedulingBounds(bounds);
			objRoot.addChild(capture);
		}
		
		// Add a keyboard navigator to move around
		TransformGroup vpTrans =
			su.getViewingPlatform().getViewPlatformTransform();
		KeyNavigatorBehavior keyNavBeh =
			new KeyNavigatorBehavior(vpTrans);
		keyNavBeh.setSchedulingBounds(bounds);
		objRoot.addChild(keyNavBeh);

		// Optimize the scene graph
		objRoot.compile();
		return objRoot;
	}
	private void initialize(boolean recording) {
		this.recording = recording;
		setLayout(new BorderLayout());
		GraphicsConfiguration config =
			SimpleUniverse.getPreferredConfiguration();
		canvas3D = new Canvas3D(config);
		add("Center", canvas3D);
		SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
		
		//Position the view
		TransformGroup viewingPlatformGroup =
			simpleU.getViewingPlatform().getViewPlatformTransform();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3f(0, 3, 22));
		viewingPlatformGroup.setTransform(t3d);

		BranchGroup scene = createSceneGraph(simpleU);
		simpleU.addBranchGraph(scene);

		canvas3D.getView().setBackClipDistance(300.0d);
		canvas3D.getView().setFrontClipDistance(0.1d);
		canvas3D.getView().setMinimumFrameCycleTime(20);
		canvas3D.getView().setTransparencySortingPolicy(View.TRANSPARENCY_SORT_GEOMETRY);
	}

}
