/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles.examples;
import javax.media.j3d.*;
import java.util.Enumeration;

/*
 * A 'one shot' behavior that removes a group from it's parent
 * after the specified number of seconds has elapsed.
 */
public class DelayedGroupDetachBehavior extends Behavior {
	private WakeupCondition wakeupCondition = null;
	private BranchGroup child;
	private long lastTime = 0;
	private long delay;
	private long age;

	public DelayedGroupDetachBehavior(BranchGroup aChild, Group aParent, float aDelay) {
		child = aChild;
		child.setCapability(BranchGroup.ALLOW_DETACH);
		aParent.setCapability(Group.ALLOW_CHILDREN_EXTEND);
		aParent.setCapability(Group.ALLOW_CHILDREN_WRITE);
		delay = Math.round(aDelay * 1000);
		age = 0;
	}

	public void initialize() {
		wakeupOn(getMyWakeupCondition());
		lastTime = System.currentTimeMillis();
	}

	private WakeupCondition getMyWakeupCondition(){
		if(wakeupCondition == null){
			wakeupCondition = new WakeupOnElapsedFrames(0);
		}
		return wakeupCondition;
	}
		
	public void processStimulus(Enumeration criteria) {
		while (criteria.hasMoreElements()) {
			criteria.nextElement();
			long currentTime = System.currentTimeMillis();
			long dt = Math.min(currentTime - lastTime, 33); // assume 30 fps
			age = age + dt;
			lastTime = currentTime;
			if(age >= delay){
				child.detach();
			}
			else{
				wakeupOn(getMyWakeupCondition());
			}
		}
	}

}
