/**********************************************************
Copyright (C) 2005, Michael N. Jacobs, All Rights Reserved

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

**************************************************************/
package j3d.examples.particles;

import javax.vecmath.*;
import javax.media.j3d.*;

import j3d.examples.particles.emitters.*;

/**
 * A particle system that uses a pixel as a particle.
 */
public class PointParticleSystem extends ParticleSystem {
	
	public PointParticleSystem(ParticleEmitter emitter) {
		this(emitter, new Color4f(1, 1, 1, 1));
	}
	
	public PointParticleSystem(ParticleEmitter emitter, Color3f particleColor){
		super(emitter, particleColor);
		postConstructionInitialization();
	}
	
	public PointParticleSystem(ParticleEmitter emitter, Color4f particleColor){
		super(emitter, particleColor);
		postConstructionInitialization();
	}

	/* (non-Javadoc)
	 * @see particles.ParticleSystem#createAppearance()
	 */
	protected Appearance createAppearance() {
		Appearance appearance = new Appearance();
		PointAttributes pa = new PointAttributes(2, true);
		appearance.setPointAttributes(pa);
		
		TransparencyAttributes ta = new TransparencyAttributes();
		ta.setTransparencyMode(TransparencyAttributes.NICEST);
		appearance.setTransparencyAttributes(ta);
		
		return appearance;
	}
	
	/* (non-Javadoc)
	 * @see particles.ParticleSystem#createGeometry()
	 */
	protected Geometry createGeometry() {
		PointArray geometry = new PointArray(getMaximumParticles(), getVertexFormat());
		float[] coordinates = getEmitter().getPositions();
		geometry.setCoordRefFloat(coordinates);
		
		Color4f color = getParticleColor();
		for (int i = 0; i < getMaximumParticles(); i++) {
			int ci = 4 * i;
			setParticleColor(ci, color.x, color.y, color.z, color.w);
		}
		geometry.setColorRefFloat(getColors());
					
		return geometry;
	}

	/* (non-Javadoc)
	 * @see particles.ParticleSystem#getVertexFormat()
	 */
	protected int getVertexFormat() {
		int vertexFormat =
			GeometryArray.COORDINATES
				| GeometryArray.COLOR_4
				| GeometryArray.BY_REFERENCE;
		return vertexFormat;
	}
	
	/* (non-Javadoc)
	 * @see particles.ParticleSystem#getVerticesPerParticle()
	 */
	protected int getVerticesPerParticle(){
		return 1;
	}
}
