package j3d.examples.appearance.texture.noise;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.universe.SimpleUniverse;

import javax.media.j3d.*;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import java.applet.Applet;
import java.awt.*;


public class LavaFieldMain extends Applet implements IElapsedTimeListener {
    private static final float SIDE_LENGTH = 350.0f; // Meters
    private static final int DIVISIONS = 8;
    private static final float METERS_PER_DIVISION = SIDE_LENGTH / DIVISIONS;

    private Lava lava;
    private int ticks = 0;

    public LavaFieldMain() {
        initialize();
    }

    private void initialize() {
        setLayout(new BorderLayout());
        GraphicsConfiguration config =
                SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);
        add("Center", canvas3D);
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);

        //Position the view
        TransformGroup viewingPlatformGroup =
                simpleU.getViewingPlatform().getViewPlatformTransform();
        Transform3D t3d = new Transform3D();
        t3d.rotX(-Math.PI / 2);
        t3d.setTranslation(new Vector3f(SIDE_LENGTH / 2, SIDE_LENGTH, -SIDE_LENGTH / 2));
        viewingPlatformGroup.setTransform(t3d);

        BranchGroup scene = createSceneGraph(simpleU);
        simpleU.addBranchGraph(scene);

        // Adjust the clipping planes
        canvas3D.getView().setBackClipDistance(3000.0d);
        canvas3D.getView().setFrontClipDistance(1d);
    }

    public void tick() {
        // Called when the timer wakes us up.
        lava.nextFrame(++ticks);
    }

    public BranchGroup createSceneGraph(SimpleUniverse su) {
        BranchGroup objRoot = new BranchGroup();

        lava = new Lava(SIDE_LENGTH, DIVISIONS);
        objRoot.addChild(lava);

        // Add ambient light
        BoundingSphere bounds = new BoundingSphere();
        bounds.setRadius(10000);
        AmbientLight ambient = new AmbientLight();
        ambient.setColor(new Color3f(1f, 1f, 1f));
        ambient.setInfluencingBounds(bounds);
        objRoot.addChild(ambient);

        // Add a behavior to notify us when a certain
        // amount of time has passed.  This is used
        // for animation.
        ElapsedTimeBehavior timer = new ElapsedTimeBehavior(this, 67);
        timer.setSchedulingBounds(bounds);
        objRoot.addChild(timer);

        // Add a keyboard navigator to move around
        TransformGroup vpTrans =
                su.getViewingPlatform().getViewPlatformTransform();
        KeyNavigatorBehavior keyNavBeh =
                new KeyNavigatorBehavior(vpTrans);
        keyNavBeh.setSchedulingBounds(bounds);
        objRoot.addChild(keyNavBeh);

        // Optimize the scene graph
        objRoot.compile();
        return objRoot;
    }

    public static void main(String[] args) {
        Frame frame =
                new MainFrame(new LavaFieldMain(), 600, 600);
    }

}
