/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */
package j2d.warp;

import javax.swing.*;
import javax.media.jai.JAI;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.RenderedImage;
import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * User: lyon
 * Date: Oct 31, 2005
 * Time: 6:18:31 AM
 * Copyright DocJava, Inc. 2005.
 */
public class JAIWarpDemo extends JPanel
    implements ActionListener, DemoListener {

    WarpPanel warpPanel;

    boolean showSourcePositions = true;
    boolean showDestPositions = true;
    boolean showWarpedImage = true;
    boolean magnifyDisplacements = false;

    JComboBox combo;
    JLabel pointsLabel;
    JLabel xPolyLabel, yPolyLabel;

    public static final String DELETE_ALL_STRING = "Reset and Delete all points";

    public static final String SHOW_SRC_STRING = "Show src positions";
    public static final String SHOW_DST_STRING = "Show dst positions";
    public static final String SHOW_WARP_STRING = "Show warped image";

    public static final String MAGNIFY_STRING = "Magnify displacements";

    public static final String DEGREE_1_STRING = "Degree 1 (Affine)";
    public static final String DEGREE_2_STRING = "Degree 2 (Quadratic)";
    public static final String DEGREE_3_STRING = "Degree 3 (Cubic)";

    public JAIWarpDemo(String arg) {

      ParameterBlock pb;
      try
      {
             pb = new ParameterBlock().add( new URL (arg) );
      }
      catch ( MalformedURLException e)
      { return; }
        RenderedImage im = JAI.create("url", pb, null );

        warpPanel = new WarpPanel(im);
        warpPanel.addDemoListener(this);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(7, 1));

        JButton bu;
        bu = new JButton(DELETE_ALL_STRING);
        bu.addActionListener(this);
        buttonPanel.add(bu);

        JCheckBox cb;
        cb = new JCheckBox(SHOW_SRC_STRING, true);
        cb.addActionListener(this);
        buttonPanel.add(cb);

        cb = new JCheckBox(SHOW_DST_STRING, true);
        cb.addActionListener(this);
        buttonPanel.add(cb);

        cb = new JCheckBox(SHOW_WARP_STRING, true);
        cb.addActionListener(this);
        buttonPanel.add(cb);

        cb = new JCheckBox(MAGNIFY_STRING, false);
        cb.addActionListener(this);
        buttonPanel.add(cb);

        combo = new JComboBox();
        combo.addItem(DEGREE_1_STRING);
        combo.addItem(DEGREE_2_STRING);
        combo.addItem(DEGREE_3_STRING);
        combo.addActionListener(this);
        buttonPanel.add(combo);

        pointsLabel = new JLabel("Got 0 of 3 points or pairs");
        buttonPanel.add(pointsLabel);

        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add(buttonPanel, "North");

        JPanel polyPanel = new JPanel();
        polyPanel.setLayout(new GridLayout(2, 1));

        xPolyLabel = new JLabel("x' = 0.0 + 1.0*x + 0.0*y");
        yPolyLabel = new JLabel("y' = 0.0 + 0.0*x + 1.0*y");

        polyPanel.add(xPolyLabel);
        polyPanel.add(yPolyLabel);

        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(new BorderLayout());
        masterPanel.add(polyPanel, "North");
        masterPanel.add(warpPanel, "Center");
        masterPanel.add(controlPanel, "South");

        setOpaque(true);
        add(masterPanel, BorderLayout.CENTER);
        add(new JLabel("Click and/or drag mouse to enter points."), BorderLayout.SOUTH);
    }

    public void notifyNumPoints(int points, int needed) {
        pointsLabel.setText("Got " + points + " of " + needed + " points");
    }

    public void notifyPolynomial(String xpoly, String ypoly) {
        xPolyLabel.setText(xpoly);
        yPolyLabel.setText(ypoly);
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();

        if (e.getSource() == combo) {
            int index = combo.getSelectedIndex();
            warpPanel.setDegree(index + 1);
            return;
        }

        if (DELETE_ALL_STRING.equals(s)) warpPanel.deleteAllPoints(); else if (SHOW_SRC_STRING.equals(s)) {
            showSourcePositions = !showSourcePositions;
            warpPanel.setShowSource(showSourcePositions);
        } else if (SHOW_DST_STRING.equals(s)) {
            showDestPositions = !showDestPositions;
            warpPanel.setShowDest(showDestPositions);
        } else if (SHOW_WARP_STRING.equals(s)) {
            showWarpedImage = !showWarpedImage;
            warpPanel.setShowWarped(showWarpedImage);
        } else if (MAGNIFY_STRING.equals(s)) {
            magnifyDisplacements = !magnifyDisplacements;
            warpPanel.setMagnifyDisplacements(magnifyDisplacements);
        }
    }
}
