package j2d.transforms;

import com.sun.media.jai.widget.DisplayJAI;
import futils.Futil;

import javax.media.jai.DataBufferFloat;
import javax.media.jai.*;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Oct 31, 2005
 * Time: 11:25:17 AM
 */
public class JaiDctExample {
    double[] [] workingArray;
    static SampleModel dctSampleModel;
    private PlanarImage image;
    private String imageInfo;
    private File readFile;

    public JaiDctExample(PlanarImage image) {
        this.image = image;
    }

    public static void main(String[] args) {
        new JaiDctExample();
    }

    public JaiDctExample() {
        readFile = Futil.getReadFile("select an image");
        this.image = JAI.create("fileload",
                readFile.getAbsolutePath());
        imageInfo = "Dimensions: " + image.getWidth() + "x" +
                image.getHeight() +
                " Bands:" + image.getNumBands();
        // Calculate a DCT image from the source image.
        ParameterBlock pb = (new ParameterBlock()).addSource(image);
        PlanarImage dct = JAI.create("dct", pb, null);

        // Get the DCT image data.
        int width = dct.getWidth();
        int height = dct.getHeight();
        System.out.println("dctwidth  " + width + "dctheight" + height);
        boolean colorImage = true;
        double[] dctData =
                dct.getData().getPixels(0, 0, width, height,
                        (double[]) null);
        double[] pixels = new double[dctData.length];
        System.out.println("\n\n DCTd the image\n");

        double [] mynewArray = new double[pixels.length];
        System.arraycopy(dctData, 0, mynewArray, 0, dctData.length);
        RenderedImage myRI = createRenderedImage(convertArray(mynewArray, 3), width, height, 3);
        ParameterBlock myPB = (new ParameterBlock()).addSource(myRI);
        PlanarImage idct = JAI.create("idct", myPB, null);
        pixels = idct.getData().getPixels(0, 0, width, height,
                pixels);
        BufferedImage mybi = createBI(colorImage, width, height, pixels);
        JFrame frame = new JFrame();
        frame.setTitle("DisplayJAI: " + readFile.getName());
        // Get the JFrame's ContentPane.
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        // Create an instance of DisplayJAI.
        DisplayJAI dj = new DisplayJAI(image);
        DisplayJAI myDJ = new DisplayJAI(mybi);

        // Add to the JFrame's ContentPane an instance of JScrollPane containing the
        // DisplayJAI instance.
        contentPane.add(new JScrollPane(dj), BorderLayout.WEST);
        contentPane.add(new JScrollPane(myDJ), BorderLayout.EAST);
        // Add a text label with the image information.
        contentPane.add(new JLabel(imageInfo), BorderLayout.SOUTH);
        // Set the closing operation so the application is finished.
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(400, 400); // adjust the frame size.
        frame.setVisible(true); // show the frame.

    }

    private static BufferedImage createBI(boolean colorImage,
                                          int width, int height,
                                          double[] pixels) {
        int type = colorImage ?
                BufferedImage.TYPE_3BYTE_BGR : BufferedImage.TYPE_BYTE_GRAY;
        BufferedImage bi = new BufferedImage(width, height, type);
        WritableRaster rbi = bi.getRaster();
        rbi.setPixels(0, 0, width, height, pixels);
        return bi;
    }


    // courtesy of David Webber/JAI FAQ
    public static RenderedImage createRenderedImage(float [][] theData,
                                                    int width,
                                                    int height,
                                                    int numBands) {
        int len = width * height;
        Point origin = new Point(0, 0);
        // create a float sample model
        SampleModel sampleModel =
                RasterFactory.createBandedSampleModel(DataBuffer.TYPE_FLOAT,
                        width,
                        height,
                        numBands);

        // create a compatible ColorModel
        ColorModel colourModel =
                PlanarImage.createColorModel(sampleModel);

        // create a TiledImage using the float SampleModel
        TiledImage tiledImage = new TiledImage(origin,
                sampleModel,
                width,
                height);

        // create a DataBuffer from the float[][] array
        DataBufferFloat dataBuffer = new DataBufferFloat(theData, len);

        // create a Raster
        Raster raster = RasterFactory.createWritableRaster(sampleModel,
                dataBuffer,
                origin);

        // set the TiledImage data to that of the Raster
        tiledImage.setData(raster);

        RenderedImageAdapter img =
                new RenderedImageAdapter(tiledImage);
        System.out.println("Finished createRenderedImage");
        return img;
    }


    /*
    The pixels
returned by Raster.getPixels() are band interleaved, i.e., RGBRGBRGB
    */
    public float[][] convertArray(double[]workingArray, int numOfBands) {
        int totalIndex = 0;
        int arrayLength = workingArray.length / numOfBands;
        float[][] newArray = new float [numOfBands][];
        for (int sub1 = 0; sub1 < numOfBands; sub1++) {
            int offset = sub1;
            newArray[sub1] = new float[arrayLength];
            for (int sub2 = 0; sub2 < arrayLength; sub2++) {
                newArray[sub1][sub2] =
                        (float) workingArray[offset];
                offset += numOfBands;
                totalIndex++;
            }
        }
        System.out.println("finished convertArray double[] to float[][] " +
                totalIndex);
        return newArray;
    }
}
