/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.io.gif.stills;

public class LZWCompressor {
    public static void compress(
            java.io.OutputStream os, int codesize,
            byte toCompress[]) throws java.io.IOException {
        byte c;
        short index;
        int clearcode, endofinfo, numbits, limit, errcode;
        short prefix = (short) 0xFFFF;

        BitFile bitFile = new BitFile(os);
        LZWStringTable strings = new LZWStringTable();

        clearcode = 1 << codesize;
        endofinfo = clearcode + 1;

        numbits = codesize + 1;
        limit = (1 << numbits) - 1;

        strings.clearTable(codesize);
        bitFile.writeBits(clearcode, numbits);

        for (int loop = 0; loop < toCompress.length; ++loop) {
            c = toCompress[loop];
            if ((index =
                    strings.findCharString(prefix, c)) != -1)
                prefix = index;
            else {
                bitFile.writeBits(prefix, numbits);
                if (strings.addCharString(prefix, c) > limit) {
                    if (++numbits > 12) {
                        bitFile.writeBits(clearcode, numbits - 1);
                        strings.clearTable(codesize);
                        numbits = codesize + 1;
                    }
                    limit = (1 << numbits) - 1;
                }

                prefix = (short) ((short) c & 0xFF);
            }
        }

        if (prefix != -1) {
            bitFile.writeBits(prefix, numbits);
        }

        bitFile.writeBits(endofinfo, numbits);
        bitFile.flush();
    }
}
