/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.io.gif.stills;

public class ImageDescriptor {
    public byte separator_;
    public short leftPosition_, topPosition_, width_, height_;
    private byte byte_;

    public ImageDescriptor(
            short width, short height, char separator) {
        separator_ = (byte) separator;
        leftPosition_ = 0;
        topPosition_ = 0;
        width_ = width;
        height_ = height;
        setLocalColorTableSize((byte) 0);
        setReserved((byte) 0);
        setSortFlag((byte) 0);
        setInterlaceFlag((byte) 0);
        setLocalColorTableFlag((byte) 0);
    }

    public void write(java.io.OutputStream os)
            throws java.io.IOException {
        os.write(separator_);
        BitUtils.writeWord(os, leftPosition_);
        BitUtils.writeWord(os, topPosition_);
        BitUtils.writeWord(os, width_);
        BitUtils.writeWord(os, height_);
        os.write(byte_);
    }

    public void setLocalColorTableSize(byte num) {
        byte_ |= (num & 7);
    }

    public void setReserved(byte num) {
        byte_ |= (num & 3) << 3;
    }

    public void setSortFlag(byte num) {
        byte_ |= (num & 1) << 5;
    }

    public void setInterlaceFlag(byte num) {
        byte_ |= (num & 1) << 6;
    }

    public void setLocalColorTableFlag(byte num) {
        byte_ |= (num & 1) << 7;
    }
}
