/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.io.gif.stills;

import java.io.IOException;

public class BitFile {
    java.io.OutputStream output_;
    byte buffer_[];
    int index_, bitsLeft_;

    public BitFile(java.io.OutputStream output) {
        output_ = output;
        buffer_ = new byte[256];
        index_ = 0;
        bitsLeft_ = 8;
    }

    public void flush() throws java.io.IOException {
        int numBytes = index_ + (bitsLeft_ == 8 ? 0 : 1);
        if (numBytes > 0) {
            pack(numBytes);
        }
    }

    public void writeBits(int bits, int numbits)
            throws java.io.IOException {
        int bitsWritten = 0;
        int numBytes = 255;
        do {
            if ((index_ == 254 && bitsLeft_ == 0)
                    || index_ > 254) {
                pack(numBytes);

            }

            if (numbits <= bitsLeft_) {
                buffer_[index_] |= (bits & ((1 << numbits) - 1)) <<
                        (8 - bitsLeft_);
                bitsWritten += numbits;
                bitsLeft_ -= numbits;
                numbits = 0;
            } else {
                buffer_[index_] |= (bits & ((1 << bitsLeft_) - 1)) <<
                        (8 - bitsLeft_);
                bitsWritten += bitsLeft_;
                bits >>= bitsLeft_;
                numbits -= bitsLeft_;
                buffer_[++index_] = 0;
                bitsLeft_ = 8;
            }
        } while (numbits != 0);
    }

    private void pack(int numBytes) throws IOException {
        output_.write(numBytes);
        output_.write(buffer_, 0, numBytes);

        buffer_[0] = 0;
        index_ = 0;
        bitsLeft_ = 8;
    }
}
