package j2d.hpp.unhe24Bit;

import j2d.ImageProcessorInterface;
import j2d.ShortImageBean;

import java.awt.*;

/**
 * Created by Robert Distinti.
 */
public class ImageUNAHE implements ImageProcessorInterface {
    private MySingleColorStats r,g,b;
    private ShortImageBean src;

    private final void addColor(int c){
        short b=(short)(c&0xFF);
        short g=(short)(c>>8);
        short r=(short)((g>>8)&0xFF);
        g&=0xff;
        this.r.addColor(r);
        this.g.addColor(g);
        this.b.addColor(b);
    }

    private void addColors(){
        int[] pels=src.getPels();
        int i,n;
        n=pels.length;
        for(i=0; i<n; i++){
            addColor(pels[i]);
        }
        // once values are read into stats
        // now we tells that stats guys to perfrom processing
        // to determine the equalization values
        r.processHistoGram();
        g.processHistoGram();
        b.processHistoGram();
        //r.setFullScaleEqualizationValues();
        //g.setFullScaleEqualizationValues();
       // b.setFullScaleEqualizationValues();
    }

    private ShortImageBean getEqualizedImage(){
        ShortImageBean rtn=new ShortImageBean(src.getWidth(),src.getHeight());
        int x,y,xx,yy,c;

        xx=src.getWidth();
        yy=src.getHeight();
        short [][] newR=new short[xx][yy];
        short [][] newG=new short[xx][yy];
        short [][] newB=new short[xx][yy];
        short [][] oldR=src.getR();
        short [][] oldG=src.getG();
        short [][] oldB=src.getB();
        for(x=0; x<xx; x++){
            for(y=0; y<yy; y++){
                newR[x][y]=r.getHistoGramEqualizedValue(oldR[x][y]);
                newG[x][y]=g.getHistoGramEqualizedValue(oldG[x][y]);
                newB[x][y]=b.getHistoGramEqualizedValue(oldB[x][y]);
            }
        }
        rtn.setR(newR);
        rtn.setG(newG);
        rtn.setB(newB);
        return rtn;
    }



    public Image process(Image image) {
        r=new MySingleColorStats();
        g=new MySingleColorStats();
        b=new MySingleColorStats();
        src=new ShortImageBean(image);
        addColors();
        return getEqualizedImage().getImage();
    }

    public ImageUNAHE(){
    }
}
