package j2d.hpp.unaheComparisons;

import math.fourierTransforms.r2.FFTrgb;

import java.awt.*;

import j2d.ShortImageBean;
import j2d.ImageProcessorInterface;
import gui.In;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Oct 30, 2005
 * Time: 10:59:51 PM
 */
public class myImageCritic implements ImageProcessorInterface  {
    private static final int mask=100;

    private MySingleColorStats r,g,b;
    private ShortImageBean src;

    private final void addColor(int c){
        short b=(short)(c&0xFF);
        short g=(short)(c>>8);
        short r=(short)((g>>8)&0xFF);
        g&=0xff;
        this.r.addColor(r);
        this.g.addColor(g);
        this.b.addColor(b);
    }

    private void addColors(){
        int[] pels=src.getPels();
        int i,n;
        n=pels.length;
        for(i=0; i<n; i++){
            addColor(pels[i]);
        }
    }

public Image process(Image image) {
        int rtn=0;
        int h,w,h2,w2,ch,cw,iw,ih,hw;
        double W,H;
        short[][] r1,g1,b1,r2,g2,b2;
        r=new MySingleColorStats();
        g=new MySingleColorStats();
        b=new MySingleColorStats();

        Image q;
        ShortImageBean fimg1 = new ShortImageBean(image);
        w=fimg1.getWidth();
        h=fimg1.getHeight();

        W=Math.log((double)w)/Math.log(2f);
        H=Math.log((double)h)/Math.log(2f);
        w2=1<<(int)Math.ceil(W);
        h2=1<<(int)Math.ceil(H);
        hw=Math.max(h2,w2);
        // now copy
        ShortImageBean sqrimg=new ShortImageBean(hw,hw);

        r1=fimg1.getR();
        g1=fimg1.getG();
        b1=fimg1.getB();
        r2=sqrimg.getR();
        g2=sqrimg.getG();
        b2=sqrimg.getB();
        for(ih=0; ih<hw; ih++){
            for(iw=0;iw<hw;iw++){
                r2[ih][iw]=r1[ih][iw];
                g2[ih][iw]=g1[ih][iw];
                b2[ih][iw]=b1[ih][iw];
            }
        }
        q=sqrimg.getImage();
        new myImageViewer("squared", q);

        FFTrgb aFFT=new FFTrgb();
        aFFT.forward2dFFT(sqrimg.getRedPels(),sqrimg.getGreenPels(),sqrimg.getBluePels(),hw,hw);
        //q=fimg1.getImage();
        //new myImageViewer("FFT", q);
        aFFT.reverse2dFFT();
        new myImageViewer("reverseFFT test", aFFT.getShortImageBean().getImage());

        aFFT.forward2dFFT(sqrimg.getRedPels(),sqrimg.getGreenPels(),sqrimg.getBluePels(),hw,hw);
        aFFT.maskImage(1);
        aFFT.reverse2dFFT();
        src=aFFT.getShortImageBean();
        new myImageViewer("reverse_masked test",src.getImage());

       addColors();
       short rAvg=r.getAverage();
       short gAvg=g.getAverage();
       short bAvg=b.getAverage();

       float momentR=r.getHighMoment(rAvg)+r.getLowMoment(rAvg);
       float momentG=g.getHighMoment(gAvg)+g.getLowMoment(gAvg);
       float momentB=b.getHighMoment(bAvg)+b.getLowMoment(bAvg);

       float value=(momentR+momentG+momentB)/3;
       In.message("The Image quality factor is "+value+". Thats my Final answer!");

        return image;
    }
}
