package j2d.hpp.unaheComparisons;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Oct 9, 2005
 * Time: 2:30:06 PM
 * Same as RGB color Stats except this only cares about one color of the colro dimension
 */
public class MySingleColorStats {
    private ColorLink pFirst=null;
    private ColorLink pFirstSort=null;
    int totalCount=0;
    int totalUniqueValues=0;
    double deltaV;
    double minV;
    double maxV;


    private class ColorLink{
        public ColorLink pNext=null;
        public ColorLink pNextSort=null;
        public short myColor;
        public short myCount;
        public double PMF;
        public double CMF;
        public ColorLink(short color){
            PMF=0.0;
            CMF=0.0;
            myColor=color;
            myCount=1;
            totalUniqueValues++;
        }
    }


    public short getAverage(){
        ColorLink pN=pFirst;
        float accum=0;
        while(pN!=null){
            accum=accum+(float)pN.myColor*pN.myCount;
            pN=pN.pNext;
        }
        accum=accum/totalCount;
        return (short)accum;
    }

    public float getHighMoment(short center){
        ColorLink pN=pFirst;
        float accum=0;
        while(pN!=null){
            if(pN.myColor>center){
                accum=accum+(float)pN.myColor*pN.myCount*(pN.myColor-center)/255f;
            }
            pN=pN.pNext;
        }
        accum=accum/totalCount;
        return accum;
    }

    public float getLowMoment(short center){
        ColorLink pN=pFirst;
        float accum=0;
        while(pN!=null){
            if(pN.myColor<center){
                accum=accum+(float)pN.myColor*pN.myCount*(center-pN.myColor)/255f;
            }
            pN=pN.pNext;
        }
        accum=accum/totalCount;
        return accum;
    }

    public void addColor(short color){
        // first see if color in the list
        ColorLink pN=pFirst;
        ColorLink pL=null;
        totalCount++;
        if(pFirst==null){
            pFirst=new ColorLink(color);
            return;
        }

        while(pN!=null){
            if(pN.myColor==color){
                pN.myCount++;
                return;
            }
            pL=pN;
            pN=pN.pNext;
        }

        pL.pNext=new ColorLink(color);
    }

    private void addToSort(ColorLink pAdd){
        if (pFirstSort==null){
            pFirstSort=pAdd;
            pAdd.pNextSort=null;
            return;
        }
        ColorLink pS=pFirstSort;
        ColorLink pL=null;
        while(pS!=null){
            if(pS.myColor>=pAdd.myColor){
                //insert here
                if(pL==null){
                    pAdd.pNextSort=pS;
                    pFirstSort=pAdd;
                }else{
                    pAdd.pNextSort=pS;
                    pL.pNextSort=pAdd;
                }
                return;
            }
            pL=pS;
            pS=pS.pNextSort;
        }
        // if we got here it means we got to end (pL=end)
        pL.pNextSort=pAdd;
        pAdd.pNextSort=null;
    }


    public void processHistoGram(){
        ColorLink pN;
        pN=pFirst;
        minV=1000;
        maxV=0;
        while(pN!=null){
            if (maxV<pN.myColor) maxV=pN.myColor;
            if (minV>pN.myColor) minV=pN.myColor;
            addToSort(pN);
            pN=pN.pNext;
        }
        deltaV=maxV-minV;

        pN=pFirstSort;
        double CMF=0;
        double PMF=0;
        while(pN!=null){
            PMF=(double)pN.myCount/(double)totalCount;
            CMF=CMF+PMF;
            pN.CMF=CMF;
            pN.PMF=PMF;
            pN=pN.pNextSort;
        }
    }

    // Equation 4.24 on page 80 (at least this is my understanding of it)
    public short getHistoGramEqualizedValue(short c){
        ColorLink pN;
        pN=pFirstSort;
        double tmp;
        while(pN!=null){
            if(pN.myColor>=c){
                tmp=deltaV*pN.CMF+minV;
                return (short)tmp;
            }
            pN=pN.pNextSort;
        }
        return (short)(deltaV+minV);  // return max value
    }


    public void setFullScaleEqualizationValues(){
        minV=0;
        deltaV=255;
    }

    public String getStats(){
        int classCnt=0;
        ColorLink pN=pFirst;
        while(pN!=null){
            classCnt++;
            pN=pN.pNext;
        }
        return "Total pixels="+totalCount+" Total classes"+classCnt+" Unique values="+totalUniqueValues;

    }

    public void dumpSortedValue(){
        int classCnt=0;
        ColorLink pN=pFirstSort;
        while(pN!=null){
            System.out.println("color ["+pN.myColor+"] cnt["+pN.myCount+"] PMF["+pN.PMF+"] CMF["+pN.CMF+"]");
            pN=pN.pNextSort;
        }
    }

}
