/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Feb 28, 2003
 * Time: 7:44:33 AM
 */
package j2d.hpp;

import j2d.ImageProcessorInterface;

import java.awt.*;


public class ThresholdProcessor implements
        HppFilterInterface, ImageProcessorInterface {
    private double threshold;

    public ThresholdProcessor(double _b) {

        threshold = _b;

    }

    public Image process(Image img) {
        return new HppFilterImageProcessor(
                new ThresholdProcessor(threshold)
        ).process(img);
    }

    public short getR(int r) {
        return thresholdFunction(r);
    }

    public short getG(int g) {
        return thresholdFunction(g);
    }

    public short getB(int b) {
        return thresholdFunction(b);
    }

    private short thresholdFunction(double v) {
        if (v < threshold) return 0;
        return 255;
    }

}
