package j2d.hpp;

import java.awt.image.RGBImageFilter;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 14, 2005
 * Time: 2:12:27 PM
 * Copyright DocJava, 2005
 */
public class RGBFilter extends RGBImageFilter {

    public static final HppFilter3Interface   getHppFilter3Interface(final RGBImageFilter f){

        return new HppFilter3Interface() {

            public short getR(int r, int g, int b) {
                return  (short)((f.filterRGB(r,g,b) & 0xff0000)>>16);
            }

            public short getG(int r, int g, int b) {
                return  (short)((f.filterRGB(r,g,b) & 0xff00)>>8);
            }

            public short getB(int r, int g, int b) {
                return  (short)(f.filterRGB(r,g,b) & 0xff);
            }
        };

    }
    public int filterRGB(int x, int y, int rgb) {
        int b = rgb & 0xff;
        int g = (rgb & 0xff00)>>8;
        int r = (rgb & 0xff0000)>>16;
        int a = (rgb & 0xff000000)>>24;
        int gray = 0xff&((r + g + b) / 3);
        r = gray;
        b = gray;
        g = gray;
        // need an int that has argb;

        return (a<<24)|(r<<16)|(g<<8)|b;
    }
}
