/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 1, 2003
 * Time: 9:45:14 AM
 */
package j2d.hpp;

import j2d.ImageProcessorInterface;
import j2d.ShortImageBean;

import java.awt.*;

public class HppFilter3ImageProcessor
        implements ImageProcessorInterface {
    private HppFilter3Interface f = null;


    public HppFilter3ImageProcessor(HppFilter3Interface _f) {
        f = _f;
    }

    public Image process(Image img) {
        ShortImageBean sib = new ShortImageBean(img);
        short r[][] = sib.getR();
        short g[][] = sib.getG();
        short b[][] = sib.getB();
        short red, green, blue;
        for (int x = 0; x < r.length; x++)
            for (int y = 0; y < r[0].length; y++) {
                red = f.getR(r[x][y], g[x][y], b[x][y]);
                green = f.getG(r[x][y], g[x][y], b[x][y]);
                blue = f.getB(r[x][y], g[x][y], b[x][y]);

                r[x][y] = clip(red);
                g[x][y] = clip(green);
                b[x][y] = clip(blue);
            }
        return sib.getImage();
    }

    private static final short clip(short s) {
        if (s < 0) return 0;
        if (s > 255) return 255;
        return s;
    }

}
