/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package j2d.hpp;

import gui.run.RunButton;
import gui.run.RunSlider;
import ip.gui.frames.HistogramFrame;
import j2d.ImageProcessListener;
import j2d.ShortImageBean;

import javax.swing.*;
import java.awt.*;

public class HistogramPanel
        extends JPanel {

    ImageProcessListener ipl = null;


    public HistogramPanel(ImageProcessListener _ipl) {
        ipl = _ipl;

        setLayout(new GridLayout(0,1));

        add(new RunSlider(1, 100, 50) {
            public void run() {
                enahe(getValue());
            }
        });
        add(new RunButton("unahe") {
            public void run() {
                updateImage();
            }
        });
        add(new RunButton("showAndRegister histogram"){
            public void run(){
                showHistogram();
            }
        });

    }





    private void showHistogram() {
        ShortImageBean shortImageBean = new ShortImageBean(ipl.getImage());
        HistogramFrame rh = new HistogramFrame(shortImageBean.getR(), "Red");
        HistogramFrame gh = new HistogramFrame(shortImageBean.getG(), "Green");
        HistogramFrame bh = new HistogramFrame(shortImageBean.getB(), "Blue");
        rh.myShow();
        gh.myShow();
        bh.myShow();
    }

    private void enahe(double alpha) {
        EnaheFilter e = new EnaheFilter(ipl.getImage(), alpha / 10.0);
        ipl.update(new HppFilterImageProcessor(e));
    }

    private void updateImage() {
        EqualizationFilter cf = new EqualizationFilter(
                ipl.getImage());
        ipl.update(new HppFilterImageProcessor(cf));

    }

}
