// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.hpp;

/**
 * This class provides some image processing on an image by generating false
 * color.  If the input image is color, it is converted to grayscale before
 * the false color is applied.
 *
 * The source of this method of false coloring is the following paper:
 * C.W.A.M. van Overfeld, "Color Waves: A Simple Heuristic for Choosing
 * False Colors", Journal of Graphics Tools, Vol. 2, No. 4: 45-50
 */
public class FalseColorProcessor extends j2d.ImageProcessor {

    private int lookupTable[][] = new int[3][256];

    /**
     * Create a new FalseColorProcessor
     */
    public FalseColorProcessor(){
        for (int i = 0; i<3; i++)
            for (int j = 0; j<256; j++)
                lookupTable[i][j] = j;
    }
    /**
     * Implementation of ImageProcessor
     */
    public void processImage() throws Exception{
        int pixels[];
        int r, g, b, gray;

        pixels = getPixels();

        for (int i = 0; i<pixels.length; i++){

            // separate RGB components
            r = (pixels[i] & 0x00FF0000) >> 16;
            g = (pixels[i] & 0x0000FF00) >> 8;
            b = (pixels[i] & 0x000000FF);

            // if color, convert to grayscale here.
            gray = (r + g + b)/3;

            // add the false color
            r = lookupTable[0][gray];
            g = lookupTable[1][gray];
            b = lookupTable[2][gray];

            // store the processed pixel
            pixels[i] = 0xFF000000 | (r << 16) | (g << 8) | b;
        }

        setPixels(pixels);
    }

    /**
     * Set the colorization parameters.  The values must be between
     * 0.01 and 0.5.
     */

    public void setColorization(double ar, double ag, double ab){
        double a[] = new double[3];

        a[0] = ar;
        a[1] = ag;
        a[2] = ab;

        for (int i = 0; i < 3; i++){
            for (int j = 0; j<256; j++){
                lookupTable[i][j] = (int)(255 * (0.5 + 0.5*Math.sin(a[i] * j)));
            }
        }
    }
}