/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.hpp;

import j2d.ImageUtils;

import javax.media.jai.Histogram;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROIShape;
import java.awt.geom.Rectangle2D;
import java.awt.image.renderable.ParameterBlock;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: May 31, 2005
 * <p/>
 * Time: 8:36:16 AM
 * This class contains methods that I am
 * not able to make work. The parameter blocks
 * are not strongly typed at compile time.
 * What is going on here?
 * Why don't we have peer methods that
 * give use a bit of guidance when
 * using these routines?
 */
public class BuggyHistogram {
    public static void testGetHistoGram() {
        final PlanarImage planarImage = ImageUtils.getPlanarImage(
                ImageUtils.getImage());

        getHistogram(planarImage, getROIShape(planarImage));
    }

    private static ROIShape getROIShape(PlanarImage image) {
        Rectangle2D r = new Rectangle2D.Double(
                0, 0, image.getWidth(), image.getHeight());
        return new ROIShape(r);
        }

    public static Histogram getHistogram(PlanarImage image, ROIShape roi) {
        int[] bins = {256, 256, 256};             // The number of bins.
        double[] low = {0.0D, 0.0D, 0.0D};        // The low value.
        double[] high = {256.0D, 256.0D, 256.0D}; // The high value.
        // Construct the Histogram object.
        Histogram hist = new Histogram(bins, low, high);
        // Create the parameter block.
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);               // Specify the source image
        pb.add(hist);                      // Specify the histogram
        pb.add(roi);                      // No ROI
        pb.add(1);                         // Sampling
        pb.add(1);                         // periods
        // Perform the histogram operation.
        PlanarImage dst = JAI.create("histogram", pb, null);
        // Retrieve the histogram data.
        hist = (Histogram) dst.getProperty("histogram");
        // Print 3-band histogram.
        for (int i = 0; i < hist.getNumBins().length; i++) {
            System.out.println(
                    hist.getBinSize(0, i) +
                    " " +
                    hist.getBinSize(1, i) +
                    " " +
                    hist.getBinSize(2, i) + " ");
        }
        return hist;
    }
}
