package j2d.gui.menu;

import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.hpp.GreyHppFilter3Panel;
import j2d.hpp.ThresholdFilter3Panel;
import j2d.hpp.ThresholdPanel;
import j2d.hpp.ContrastPanel;
import j2d.ShortImageBean;

import java.awt.*;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 2, 2005
 * Time: 6:14:37 PM
 */
public class HppMenu {
    public static void addHppMenu(RunMenu processMenu, final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Hpp");
        rm.add(
                new RunMenuItem("GreyHppFilter3Panel") {
                    public void run() {
                        main.addPanel(
                                new GreyHppFilter3Panel(main), getText());
                    }
                });
              rm.add(new RunMenuItem("ThresholdFilter3Panel") {
            public void run() {
                main.addPanel(new ThresholdFilter3Panel(main), getText());
            }
        });
        rm.add(new RunMenuItem("ThresholdPanel") {
            public void run() {
                main.addPanel(new ThresholdPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("GreyHppFilter3Panel") {
            public void run() {
                main.addPanel(new GreyHppFilter3Panel(main), getText());
            }
        });
        rm.add(new RunMenuItem("ContrastPanel") {
            public void run() {
                main.addPanel(new ContrastPanel(main), getText());
            }
        });
        rm.add(
                new RunMenuItem("ThresholdFilter3Panel") {
                    public void run() {
                        main.addPanel(
                                new ThresholdFilter3Panel(main),
                                getText());
                    }
                });
        rm.add(
                new RunMenuItem("ThresholdPanel") {
                    public void run() {
                        main.addPanel(
                                new ThresholdPanel(main), getText());
                    }
                });
        //
        rm.add(
                new RunMenuItem("salt and pepper 1000") {
                    public void run() {
                        Image img = main.getImage();
                        ShortImageBean sib = new ShortImageBean(img);
                        sib.saltAndPepper(1000);
                        main.setImage(sib.getImage());
                    }
                });
        processMenu.add(rm);
    }
}
