package j2d.gui.menu;

import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.hpp.unaheComparisons.myImageCritic;
import j2d.hpp.HistogramPanel;
import j2d.hpp.ContrastPanel;
import j2d.color.rgbImageFilters.LogXformPanel;
import j2d.ShortImageBeans;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import utils.ResourceManager;

import java.io.File;
import java.awt.*;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 2, 2005
 * Time: 5:47:52 PM
 */
public class HistogramMenu {
    public static RunMenu getHistogramMenu(final j2d.gui.Main main) {
        RunMenu processMenu = new RunMenu("[Histogram");
        processMenu.add(
                new RunMenuItem("Get imagic number") {
                    public void run() {
                        main.process(new myImageCritic());
                    }
                });
        processMenu.add(
                new RunMenuItem("H[istogram Panel{ctrl i}") {
                    public void run() {
                        HistogramPanel cp = new HistogramPanel(main);
                        main.addPanel(cp, getText());
                    }
                });
        processMenu.add(
                new RunMenuItem("[Exponential Stretch") {
                    public void run() {
                        if (main.estStretchControls == null ||
                                main.estStretchControls.isClosed()) {
                            main.launchStretchControls();
                        }
                    }
                });
        processMenu.add(
                new RunMenuItem("showAndRegister images{alt ctrl S}") {
                    public void run() {
                        showImageSequence();
                    }
                });
        processMenu.add(
                new RunMenuItem("append images{alt ctrl A}") {
                    public void run() {
                        appendImages(main);
                    }
                });
        processMenu.add(
                new RunMenuItem("[ContrastPanel{alt ctrl C}") {
                    public void run() {
                        ContrastPanel cp = new ContrastPanel(main);
                        main.addPanel(cp, getText());
                    }
                });
   
        return processMenu;
    }

    private static void appendImages(j2d.gui.Main main) {
        ResourceManager rm = ResourceManager.getResourceManager();
        File f[] = rm.getImages();
        ShortImageBeans sibs = new ShortImageBeans();
        for (int i = 0; i < f.length; i++) {
            final Image image = ImageUtils.getImage(f[i]);
            if (image == null) continue;
            sibs.add(
                    new ShortImageBean(
                            ImageUtils.scaleFast(
                                    image, 64, 64)));
        }
        Image imgs[] = sibs.getImages();
        final int n = (int) Math.sqrt(imgs.length);
        Image img =
                ImageUtils.concatenateImages(
                        imgs, new Dimension(64, 64), n, n);
        main.addImage(img);
    }

    private static void showImageSequence() {
        ResourceManager rm = ResourceManager.getResourceManager();
        File f[] = rm.getImages("jpg");
        ShortImageBeans sibs = new ShortImageBeans();
        for (int i = 0; i < f.length; i++) {
            sibs.add(
                    new ShortImageBean(
                            ImageUtils.scaleFast(
                                    ImageUtils.getImage(f[i]), 64, 64)));
        }

        sibs.show(10, 10);
    }
}
