package j2d.gui.menu;

import gui.run.RunMenu;
import gui.run.RunMenuItem;

import java.awt.*;

import j2d.ImageUtils;
import ip.transforms.Kernels;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 2, 2005
 * Time: 5:47:28 PM
 */
public class FilterMenu {
    public static RunMenu getFilterMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("F[ilter");
        rm.add(EdgeMenu.getEdgeMenu(main));
        rm.add(BlurMenu.getBlurMenu(main));

        rm.add(getHpMenu(main));
        rm.add(getLpMenu(main));
        rm.add(getMedianMenu(main));
        rm.add(getOtherTransformsMenu(main));
        rm.add(
                new RunMenuItem("BorderPanel") {
                    public void run() {
                        main.addPanel(
                                new j2d.border.BorderPanel(main),
                                getText());
                    }
                });
        rm.add(
                new RunMenuItem("Convolution") {
                    public void run() {
                        main.launchConvolutionControls();
                        //     Image img = main.getImage();
                        //     bufferedImageConvolution.ImageMatrix im=new bufferedImageConvolution.ImageMatrix(img);
                        //     main.setImage(im.getImage());
                    }
                });

        return rm;
    }

    public static RunMenu getHpMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Hp");
        rm.add(
                new RunMenuItem("Hp1") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHp1());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Hp2") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHp2());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Hp3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHp3());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Hp4") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHp4());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Hp5") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHp5());
                        main.setImage(img);
                    }
                });

        return rm;
    }

    public static RunMenu getLpMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Lp");
        rm.add(
                new RunMenuItem("Lp1") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLp1());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Lp2") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLp2());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Lp3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLp3());
                        main.setImage(img);
                    }
                });

        return rm;
    }

    public static RunMenu getOtherTransformsMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Other Filters");
        rm.add(
                new RunMenuItem("Average 3x3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getAverage3x3());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Gabor 7") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getGabor7());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Hat 13") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getHat13());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Mean 3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getMean3());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Mean 9") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getMean9());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Sobel") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getSobel());
                        main.setImage(img);
                    }
                });

        return rm;
    }

    public static float[][] shortMatrixToFloat(short sm[][]) {
        float[][] fm = new float[sm.length][sm[0].length];

        for (int x = 0; x < sm.length; x++)
            System.arraycopy(sm[x], 0, fm[x], 0, sm[x].length);
        return fm;
    }

    public static RunMenu getMedianMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Median Filters");
        rm.add(
                new RunMenuItem("Median 1x2") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedian1x2()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median 2x1") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedian2x1()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Cross 3x3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianCross3x3()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Cross 5x5") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianCross5x5()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Cross 7x7") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianCross7x7()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Diamond") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianDiamond()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Octagon 5x5") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianOctagon5x5()));
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Median Square 7x7") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                shortMatrixToFloat(
                                        Kernels.getMedianSquare7x7()));
                        main.setImage(img);
                    }
                });


        return rm;
    }
}
