package j2d.gui.menu;

import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.edge.*;
import j2d.ImageUtils;

import java.awt.*;

import ip.transforms.Kernels;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 2, 2005
 * Time: 5:46:42 PM
 */
public class EdgeMenu {
    public static RunMenu getEdgeMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Edge");
        rm.add(getRobinsonMenu(main));
        rm.add(getLaplacianMenu(main));
        rm.add(
                new RunMenuItem("[HoughPanel") {
                    public void run() {
                        main.addPanel(new HoughPanel(main), getText());
                    }
                });
        rm.add(
                new RunMenuItem("[CannyPanel{alt ctrl c}") {
                    public void run() {
                        main.addPanel(new CannyPanel(main), getText());
                    }
                });
        rm.add(
                new RunMenuItem("[LoGSobelPanel{alt ctrl s}") {
                    public void run() {
                        main.addPanel(new LoGSobelPanel(main), getText());
                    }
                });
        rm.add(
                new RunMenuItem("[MagDOGPanel{alt ctrl d}") {
                    public void run() {
                        main.addPanel(new MagDOGPanel(main), getText());
                    }
                });
        rm.add(
                new RunMenuItem("[SobelPanel{alt ctrl o}") {
                    public void run() {
                        main.addPanel(new SobelPanel(main), getText());
                    }
                });
        rm.add(
                new RunMenuItem("MehrotraAndZhangPanel{alt ctrl z}") {
                    public void run() {
                        main.addPanel(
                                new MehrotraAndZhangPanel(main),
                                getText());
                    }
                });
        rm.add(
                new RunMenuItem("[TemplatePanel{alt ctrl t}") {
                    public void run() {
                        main.addPanel(new TemplatePanel(main), getText());
                    }
                });//

        return rm;
    }

    public static RunMenu getRobinsonMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Robinson");

        rm.add(
                new RunMenuItem("Robinson1") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson1());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson2") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson2());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson3());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson4") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson4());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson5") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson5());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson6") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson6());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson7") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson7());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("Robinson8") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getRobinson8());
                        main.setImage(img);
                    }
                });
        return rm;
    }

    public static RunMenu getLaplacianMenu(final j2d.gui.Main main) {
        RunMenu rm = new RunMenu("Laplacian");
        rm.add(
                new RunMenuItem("L3") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLaplacian3());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("L5") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLaplacian5());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("L9") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img, Kernels.getLaplacian9());
                        main.setImage(img);
                    }
                });
        rm.add(
                new RunMenuItem("L-Prewitt") {
                    public void run() {
                        Image img = main.getImage();
                        img
                                = ImageUtils.convolution(
                                img,
                                Kernels.getLaplacianPrewitt());
                        main.setImage(img);
                    }
                });

        return rm;
    }
}
