/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.gui.menu;

import gui.ClosableJFrame;
import gui.run.Matrix3dView;
import gui.run.RunColor3dPanel;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.ShortImageBean;
import j2d.animation.AnimationPanel;
import j2d.color.*;
import j2d.color.quantization.ColorFrame;
import j2d.color.quantization.MedianCutPanel;
import j2d.color.quantization.OctreePanel;
import j2d.color.quantization.WuPanel;
import j2d.color.rgbImageFilters.*;
import j2d.filters.GaussianPanel;
import j2d.gui.Main;
import j2d.hpp.InvertFilter;
import video.jsnap.NqController;

import javax.vecmath.Matrix3d;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 21, 2005
 * <p/>
 * Time: 9:30:40 AM
 */
public class ColorMenu {

    public static RunMenu getColorQuantizationMenu(final Main main) {
        final RunMenu rm = new RunMenu("[quantization");
        rm.add(new RunMenuItem("[fastColorSafe colors{control c}") {
            public void run() {
                main.process(new ColorSafeFilter());
            }
        });
        rm.add(new RunMenuItem("linearCut") {
            public void run() {
                main.addPanel(new LinearCutPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("median cut") {
            public void run() {
                main.addPanel(new MedianCutPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("wu") {
            public void run() {
                main.addPanel(new WuPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("wu-256") {
            public void run() {
                main.process(Wu.getImageProcessorInterface(256));
            }
        });
        rm.add(new RunMenuItem("octree") {
            public void run() {
                main.addPanel(new OctreePanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("print number of colors") {
            public void run() {
                final Image image = main.getImage();
                final ColorFrame cf = new ColorFrame();
                cf.setImage(image);
                cf.printNumberOfColors();
                main.setImage(cf.getImage());
            }
        });
        rm.add(new RunMenuItem("nuQuant256") {
            public void run() {
                main.process(NqController.getImageProcessorInterface());
            }
        });
        return rm;
    }

    public static RunMenu getColorMenu(final Main main) {
        final RunMenu rm = new RunMenu("[Color");
        rm.add(getColorQuantizationMenu(main));
        rm.add(getColorSwapMenu(main));
        rm.add(new RunMenuItem("Pse[udoColorFilter") {
            public void run() {
                main.addPanel(new ColorizerPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("ColorSpacePanel") {
            public void run() {
                main.addPanel(new ColorSpacePanel(main), getText());
            }
        });

        rm.add(new RunMenuItem("GaussianPanel") {
            public void run() {
                main.addPanel(new GaussianPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("AnimationPanel") {
            public void run() {
                main.addPanel(new AnimationPanel(main), getText());
            }
        });
  
        //
        rm.add(new RunMenuItem("gray") {
            public void run() {
                final Image img = main.getImage();
                final ShortImageBean sib = new ShortImageBean(img);
                sib.gray();
                main.setImage(sib.getImage());
            }
        });
        rm.add(new RunMenuItem("[negate{ctrl C}") {
            public void run() {
                main.process(new InvertFilter());
            }
        });

        rm.add(new RunMenuItem("rgb2iyq") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yiq.getRgb2yiqMat()));
            }
        });
        rm.add(new RunMenuItem("iyq2rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yiq.getYiq2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("rgb2hsb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Ccir601_2cbcr.getCycbcr2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("hsb2rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Ccir601_2cbcr.getRgb2cycbcrMat()));
            }
        });
        rm.add(new RunMenuItem("rgb2Xyzd65") {
            public void run() {
                main.process(new FloatColorConverterInterface(Xyzd65.getRgb2xyzMat()));
            }
        });
        rm.add(new RunMenuItem("Xyzd652rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Xyzd65.getXyz2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("rgb2yuv") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yuv.getRgb2yuvMat()));
            }
        });
        rm.add(new RunMenuItem("yuv2rgb") {
            public void run() {
                main.process(new FloatColorConverterInterface(Yuv.getYuv2rgbMat()));
            }
        });
        rm.add(new RunMenuItem("showAndRegister color panel (buggy?)") {
            public void run() {
                showColorPanel(main);

            }
        });
        //Yuv
        return rm;
    }

    private static RunMenu getColorSwapMenu(final Main main) {
        final RunMenu rm = new RunMenu("color [swap");
        rm.add(new RunMenuItem("RgbFilterPanel") {
            public void run() {
                main.addPanel(new RgbFilterPanel(main), getText());
            }
        });
        rm.add(new RunMenuItem("get red") {
            public void run() {
                main.process(new RedFilter());
            }
        });
        rm.add(new RunMenuItem("get green") {
            public void run() {
                main.process(new GreenFilter());
            }
        });
        rm.add(new RunMenuItem("get blue") {
            public void run() {
                main.process(new BlueFilter());
            }
        });
        rm.add(new RunMenuItem("SwapGreenBlueFilter") {
            public void run() {
                main.process(new SwapGreenBlueFilter());
            }
        });
        rm.add(new RunMenuItem("SwapRedBlueFilter") {
            public void run() {
                main.process(new SwapRedBlueFilter());
            }
        });
        rm.add(new RunMenuItem("SwapRedGreenFilter") {
            public void run() {
                main.process(new SwapRedGreenFilter());
            }
        });
        return rm;
    }

    // todo: debug this showColorPanel
    private static void showColorPanel(final Main main) {
        final ClosableJFrame cf = new ClosableJFrame();
        final Container c = cf.getContentPane();
        final Matrix3dView view = new Matrix3dView();
        c.add(new RunColor3dPanel() {
            public void run() {
                final Matrix3d value = getValue();
                //System.out.println(value);
                view.updateView(value);
                main.process(new FloatColorConverterInterface(value));
            }
        });

        c.add(view);
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

}
