// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

// Reference:
// http://java.sun.com/products/java-media/jmf/2.1.1/solutions/video.jmf.JVidCap.html

import gui.run.RunButton;

import javax.media.Buffer;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.*;
import javax.media.util.BufferToImage;
import javax.swing.*;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import java.awt.*;
import java.io.IOException;

/**
 * MDI child frame for displaying a video preview
 */
public class VideoCaptureChildFrame
        extends JInternalFrame
        implements BufferTransferHandler {

    private ImagePanel ipnDisplay;

    private VideoFormat vfFormat;
    private PushBufferDataSource pbds;
    private Buffer cbuffer;

    /**
     * Construct a new VideoCaptureChildFrame
     */
    public VideoCaptureChildFrame(PushBufferDataSource pbds, VideoFormat vf) {
        this.vfFormat = vf;
        this.pbds = pbds;

        setTitle("Video Monitor");

        ipnDisplay = new ImagePanel();

        Container c = getContentPane();
        c.setLayout(new BorderLayout());
        c.add(ipnDisplay, BorderLayout.CENTER);


        JPanel x = new JPanel();
        x.setLayout(new FlowLayout(FlowLayout.RIGHT));
        x.add(new RunButton("Grab Frame"){
            public void run() {
                 startVideo();
            }
        });
        c.add(x, BorderLayout.SOUTH);

        setMinimumSize(new Dimension(100, 100));
        setClosable(true);
        setMaximizable(false);
        setResizable(false);

// Make sure that the camera data source is closed
// when the frame is closed.

        addInternalFrameListener(new InternalFrameAdapter() {
            public void internalFrameClosing(InternalFrameEvent e) {
                stopVideo();
            }
        });
    }

    /**
     * Begin monitoring video
     */
    public void startVideo() {

        // Adjust the side of the window to match the
        // video size
        ipnDisplay.setPreferredSize(vfFormat.getSize());
        pack();

        try {
            // Initialize the transfer buffer
            cbuffer = new Buffer();

            // Open the data source and set its format
            pbds.connect();

            FormatControl[] fcs = ((CaptureDevice) pbds).getFormatControls();
            FormatControl fc = fcs[0];
            fc.setFormat(vfFormat);

            // Set up the monitor for the stream
            SourceStream ss = pbds.getStreams()[0];
            ((PushBufferStream) ss).setTransferHandler(this);

            // Start streaming.
            pbds.start();

        } catch (Exception e) {
            JOptionPane.showMessageDialog(this,
                    "Error starting video monitor." + "\n" +
                    e.getMessage());
        }
    }

    /**
     * Stop monitoring video
     */
    public void stopVideo() {
        try {
            // Stop streaming and disconnect from data source.
            pbds.stop();
            pbds.disconnect();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this,
                    "Error stopping video monitor.");
        }
    }

    /**
     * Implementation of BufferTransferHandler
     */
    public void transferData(PushBufferStream stream) {
        // Get the data from the original source stream
        try {
            stream.read(cbuffer);
        } catch (IOException ioe) {
            return;
        }

        // Display data

        BufferToImage bti =
                new BufferToImage((VideoFormat) cbuffer.getFormat());
        Image im = bti.createImage(cbuffer);
        ipnDisplay.setImage(im);
    }

    /**
     * Obtain a handle to the displayed image.
     */
    public Image getImage() {
        return ipnDisplay.getImage();
    }
}