// Glenn Josefiak
// Fairfield University
// SW513
// Spring 2003

package j2d.gui;

// Reference:
// http://java.sun.com/products/java-media/jmf/2.1.1/solutions/video.jmf.JVidCap.html

import gui.run.RunButton;

import javax.media.*;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferDataSource;
import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

/**
 * Dialog box that enables selection of camera and
 * video format from those cameras installed on the
 * system.  Requires JMF to be installed.
 */
public class CameraConfigToolbox extends JDialog {
    JComboBox cboCameraSelect;
    JComboBox cboFormatSelect;


    private void apply() {
        setVisible(false);
        //todo figure this out!
    }


    PushBufferDataSource pbds = null;
    Vector YUVdevices;
    Format[] formats;

    /**
     * Create a new CameraConfigToolbox
     */
    public CameraConfigToolbox() {
        setModal(true);
        setSize(200, 200);
        Container c = getContentPane();
        c.setLayout(new FlowLayout(FlowLayout.LEFT));

        setTitle("Camera Configuration");

        cboCameraSelect = new JComboBox(new Vector());
        c.add(cboCameraSelect);
        cboCameraSelect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                initFormatList();
            }
        });

        cboFormatSelect = new JComboBox(new Vector());
        c.add(cboFormatSelect);
        c.add(new RunButton("apply") {
            public void run() {
                apply();
            }
        });
        setResizable(true);

        initCameraList();
    }

    /**
     * Populate the camera list combo box.
     */
    private void initCameraList() {
        YUVdevices = CaptureDeviceManager.getDeviceList(new YUVFormat());
        for (int i = 0; i < YUVdevices.size(); i++) {
            CaptureDeviceInfo captureDeviceInfo = (CaptureDeviceInfo) YUVdevices.elementAt(i);
            String name = captureDeviceInfo.getName();
            System.out.println("name=" + name);
            cboCameraSelect.addItem(name);
        }
    }


    public PushBufferDataSource getPushBufferDataSource() {
        return pbds;
    }

    /**
     * Populate the format list combo box.
     */
    private void initFormatList() {

        try {
            CaptureDeviceInfo cdi =
                    (CaptureDeviceInfo)
                    YUVdevices.elementAt(cboCameraSelect.getSelectedIndex());
            MediaLocator ml = cdi.getLocator();

            pbds =
                    (PushBufferDataSource) Manager.createDataSource(ml);
            pbds.connect();

            FormatControl[] fcs = ((CaptureDevice) pbds).getFormatControls();
            if (fcs.length < 1)
                return;

            FormatControl fc = fcs[0];
            formats = fc.getSupportedFormats();

            cboFormatSelect.removeAllItems();
            for (int i = 0; i < formats.length; i++) {
                String desc;
                VideoFormat vf = (VideoFormat) formats[i];

                desc = vf.getEncoding() + "; ";
                desc += vf.getSize().getWidth() + "x"
                        + vf.getSize().getHeight();

                cboFormatSelect.addItem(desc);
            }
            pbds.disconnect();
        } catch (Exception e) {
            // do nothing
        }
    }

    /**
     * Return the selected video format.
     */
    public VideoFormat getSelectedFormat() {
        return (VideoFormat) formats[cboFormatSelect.getSelectedIndex()];
    }


}