/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.filters.bufferedImageConvolution;

import java.awt.*;

import math.fourierTransforms.pfa.PFAImage;
import gui.In;
import j2d.ImageUtils;

/**
 * User: lyon
 * Date: Nov 13, 2005
 * Time: 6:17:12 PM
 * Copyright DocJava, Inc. 2005.
 */
public class PFAImageConvolver implements ImageMatrixBeanProcessorInterface {
    ImageMatrixBean imb;

    public PFAImageConvolver(ImageMatrixBean imb) {
        this.imb = imb;
    }

    //The midterm
    public Image process(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        int n=imb.getCount();
        float peak;
        float scale;
        if(n>0){
            Image KImage=imb.getImage(h,w);
            //ImageUtils.displayImage(KImage," grown kernal image");
            if(KImage.getHeight(null)==h && KImage.getWidth(null)==w){
                PFAImage fkrnl=new PFAImage(KImage);
                fkrnl.fft();
                //fkrnl.debug("Kernal Before scaling");
                peak=fkrnl.getPeakMagnitude();
                scale=1/peak;
                fkrnl.scale(scale);
                //System.out.println("\r\n Scaling factors "+scale+" old method "+257f/n+" \r\n");
                //fkrnl.debug(" Kernal ");

                PFAImage fimg = new PFAImage(image);
                fimg.fft();
                //fimg.debug(" image before multiply ");
                fimg.multiply(fkrnl);
                //fimg.debug(" after ");
                //todo decide if this is a good way to quad shift.
                //fimg.quadrantShift();
                fimg.ifft();
                return ImageUtils.quadSwap(fimg.getImage());
            }else{
                In.alert("The selected border/Kernal Growing option does not produce a kernel image of the same size as the image being processed.  Returning original image.");
                return image;
            }
        }else{
            In.alert("You can not have an empty Matrix: operation aborted!!!");
            return image;
        }
    }

    public String toString() {
        return "pfa convolution";
    }

    public void setImageMatrixBean(ImageMatrixBean imb) {
        this.imb = imb;
    }

    public ImageMatrixBean getImageMatrixBean() {
        return imb;
    }
}
