/*
* Modified from MouseCheckBoxPanel
*/
package j2d.filters.bufferedImageConvolution;

import gui.run.RunCheckBox;

import javax.swing.*;
import java.awt.*;

public class ImageCheckBoxPanel extends JPanel {
    private RunCheckBox rcb[][];
    private ImageMatrixBean myBean;

    public ImageCheckBoxPanel(ImageMatrixBean data) {
        int w = data.getMatrixSize();
        myBean = data;
        rcb = new RunCheckBox[w][w];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < w; y++) {
                RunCheckBox cb = new RunCheckBox() {
                    public void run() {
                        //System.out.println(isSelected());
                    }
                };
                add(cb);
                rcb[x][y] = cb;
            }
        setLayout(new GridLayout(w, 0, 0, 0));
        super.setToolTipText("alt turns on, control turns off");
        loadValues();
    }

    public void setBackground(Color c) {
        if (rcb == null) return;
        for (int i = 0; i < rcb.length; i++)
            for (int j = 0; j < rcb[0].length; j++)
                rcb[i][j].setBackground(c);
        super.setBackground(c);
    }


    private void loadValues() {
        byte data[][] = myBean.getData();
        // use min
        int x, y;
        x = data.length;
        y = data[0].length;
        if (x == 0 || y == 0 || rcb.length == 0 || rcb[0].length == 0) return;
        if (x > rcb.length) x = rcb.length;
        if (y > rcb[0].length) x = rcb[0].length;
        for (int i = 0; i < x; i++) {
            for (int j = 0; j < y; j++) {
                if (data[i][j] > 0) {
                    rcb[i][j].setSelected(true);
                } else {
                    rcb[i][j].setSelected(false);
                }
            }
        }
    }

    public void saveValues() {
        byte data[][] = myBean.getData();
        // use min
        int x, y;
        x = data.length;
        y = data[0].length;
        if (x == 0 || y == 0 || rcb.length == 0 || rcb[0].length == 0) return;
        if (x > rcb.length) x = rcb.length;
        if (y > rcb[0].length) x = rcb[0].length;
        for (int i = 0; i < x; i++) {
            for (int j = 0; j < y; j++) {
                if (rcb[i][j].isSelected()) {
                    data[i][j] = 1;
                } else {
                    data[i][j] = 0;
                }
            }
        }
    }
}