package j2d.filters.bufferedImageConvolution;

import j2d.ImageUtils;

import java.awt.*;


public class FFTR2ImageConvolver implements ImageMatrixBeanProcessorInterface {
    private ImageMatrixBean imb;


    public Image process(Image image) {
        image = ImageUtils.cropImageToIntegralPowerOfTwo(image);
        final int w = image.getWidth(null);
        final int h = image.getHeight(null);
        Image kernalImage = imb.getImage(w, h);
        return ImageUtils.filterFFTR2(image, kernalImage);
    }

    public FFTR2ImageConvolver(ImageMatrixBean o) {
        this.imb = o;
    }

    public void setImageMatrixBean(ImageMatrixBean imb) {
        this.imb = imb;
    }

    public ImageMatrixBean getImageMatrixBean() {
        return imb;
    }

    public String toString() {
        return "FFTR2";
    }
}

