package j2d.filters.bufferedImageConvolution;

import gui.In;
import gui.layouts.VerticalLayout;
import gui.run.RunButton;
import gui.run.RunComboBox;
import j2d.ImageProcessListener;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


/**
 * Created by Robert Distinti.
 * User: default
 * Date: Sep 19, 2005
 * Time: 1:53:41 AM
 */
public class ConvolutionControlFrame extends JInternalFrame {
    private ImageMatrixBean imb = ImageMatrixBean.restore();
    private ImageCheckBoxPanel mcbp = new ImageCheckBoxPanel(imb);
    private ImageProcessListener tgt = null;
    private RunComboBox borderComboBox = getBorderComboBox();
    private RunComboBox filterComboBox = getFilterComboBox();


    // refresh is performed whenever size has changed
    private void refresh() {
        JInternalFrame cf = this;
        Container c = cf.getContentPane();
        c.remove(mcbp);
        //make a new ImageCheckBoxPanel, from
        // the updated imb.
        mcbp = new ImageCheckBoxPanel(imb);
        c.add(mcbp, BorderLayout.CENTER);
        cf.pack();
        cf.setVisible(true);
    }

    public ConvolutionControlFrame(ImageProcessListener tg) {
        tgt = tg;
        setTitle("Select Image matrix");
        setup();
    }

    public ConvolutionControlFrame() {
        tgt = null;
        setTitle("Select Image matrix");
        setup();
    }
    //todo explain design to class.
    private RunComboBox getFilterComboBox() {
        Vector v = new Vector();
        v.addElement(new ImageConvolver(imb));
        v.addElement(new FFTR2ImageConvolver(imb));
        v.addElement(new PFAImageConvolver(imb));
        return new RunComboBox(v) {
            public void run() {
                imb.setImageProcessor(
                        (ImageMatrixBeanProcessorInterface) getSelectedItem());
                imb.setFilterType(getSelectedIndex());
                refresh();
            }
        };
    }

    private RunComboBox getBorderComboBox() {
        return new RunComboBox(new String[]{"Zero",
                "Constant",
                "Copy",
                "Reflection",
                "Wrap"}) {

            public void run() {
                imb.setBorderType((byte) getSelectedIndex());
                refresh();
            }
        };
    }

    private void setup() {
        JInternalFrame cf = this;
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());

        mcbp = new ImageCheckBoxPanel(imb);
        c.add(mcbp, BorderLayout.CENTER);

        JPanel jp = new JPanel(new VerticalLayout());
        c.add(jp, BorderLayout.EAST);

        jp.add(new RunButton("ok") {
            public void run() {
                doFilter();

            }
        });
        jp.add(new RunButton("cancel") {
            public void run() {
                imb = ImageMatrixBean.restore();
                refresh();
            }
        });
        jp.add(new RunButton("resize") {
            public void run() {
                int size = In.getInt("input an odd number", 3, 33);
                mcbp.saveValues(); // save it to bean
                imb.setMatrixSize(size);
                refresh();
            }
        });
        jp.add(borderComboBox);
        jp.add(filterComboBox);
        borderComboBox.setSelectedIndex(imb.getBorderType());
        filterComboBox.setSelectedIndex(imb.getFilterType());
        setClosable(true);
        setMaximizable(true);
        setResizable(true);
        setVisible(true);
        refresh();
    }
    // todo explain design patterns to class.
    private void doFilter() {
        mcbp.saveValues(); // save it to bean
        imb.save(); // save bean to preferences
        tgt.update(imb.getImageProcessor());
    }
}
