package j2d.edge;

import ip.transforms.Kernels;
import j2d.ImageProcessorFactory;
import j2d.ImageProcessorInterface;
import j2d.ImageUtils;
import j2d.hpp.InvertFilter;

import java.awt.*;


public class SobelProcessor
        implements ImageProcessorInterface,
        ImageProcessorFactory {

    private int a;
    private boolean isX = true;


    public SobelProcessor(int a, boolean isX) {

        this.a = a;
        this.isX = isX;
    }

    public ImageProcessorInterface getProcessor(int a) {
        return new SobelProcessor(a, isX);
    }

    public Image process(Image img) {
        return sobel(img);

    }

    private Image sobel(Image img) {
        System.out.println(" a=" + a);
        //ThresholdProcessor tp = new ThresholdProcessor(128);
        ImageProcessorInterface invert = InvertFilter.getProcessor();
        float f[][] = null;
        if (isX)
            f = Kernels.getSobelX(a);
        else
            f = Kernels.getSobelY(a);

        return
                invert.process(ImageUtils.convolution(img, f));
    }

}

