package j2d.edge;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.ImageProcessListener;

import javax.swing.*;
import java.awt.*;


public class MagDOGPanel extends JPanel {


    private int widGaussianKernel = 15;
    private double sigma = 2.0;

    ImageProcessListener ipl = null;

    /**Construct the frame*/
    public MagDOGPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    /**Component initialization*/
    private void initGuiElements() {
        setLayout(new FlowLayout());

        add(new RunButton("apply") {
            public void run() {
                updateImage();
            }
        });
        add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        add(new JLabel("kernel width"));
        add(new RunSlider(3, 40, 15) {
            public void run() {
                widGaussianKernel = getValue();
                updateImage();
            }
        });
        add(new JLabel("sigma"));
        add(new RunSlider(1, 9) {
            public void run() {
                sigma = getValue();
                updateImage();
            }
        });
    }

    public void updateImage() {
        ipl.update(new MagDOGProcessor(
                widGaussianKernel,
                sigma
        ));
    }


}
