package j2d.edge;

import j2d.*;

import java.awt.*;


public class HoughCircles
        implements ImageProcessorInterface,
        ImageProcessorFactory {
    public float radius; // Radius of circles to be found
    public int maxCircles; // Numbers of circles to be found
    public int threshold = -1; // An alternative to maxCircles
    // must lies in the interval: [-125,+125].
    // Higher values - fewer circles.
    byte imageValues[]; // Raw image (returned by ip.getPixels())
    short houghValues[][]; // Hough Space Values
    public int width; // Hough Space width
    public int height;  // Hough Space heigh
    public int offset; // Image Width
    public int offx = 0;   // ROI x offset
    public int offy = 0;   // ROI y offset
    Point centerPoint[]; // Center Points of the Circles Found.
    boolean useThreshold = false;

    ShortImageBean shortImageBean = new ShortImageBean();
    ImageBean ib = new ImageBean();

    Image temp;

    public HoughCircles(Image image) {
        ib.setImage(image);
        shortImageBean.setImage(ib.getImage());
        temp = image;
        height = shortImageBean.getHeight();
        width = shortImageBean.getWidth();
    }


    public ImageProcessorInterface getProcessor(int a) {
        return new HoughCircles(ib.getImage());
    }

    public Image process(Image img) {
        return hough(img);
    }


    private double cos(double alpha) {
        return
                Math.cos(alpha * Math.PI / 180);
    }

    private double sin(double alpha) {
        return
                Math.sin(alpha * Math.PI / 180);
    }


    public void drawHoughLine(int x, int y,
                              short s[][]) {
        for (int theta = 0; theta < s[0].length; theta++) {
            int rho = (int) (x * cos(theta) + y * sin(theta));
            if (rho >= s.length) continue;
            if (rho < 0) continue;
            s[rho][theta]++;
        }
    }


    public Image hough(Image img) {

        int thetaMax = 360;
        int radiusMax = (int) Math.sqrt(width * width + height * height);
        short houghBins[][] = new short[radiusMax][thetaMax];
        for (int x = 0; x < shortImageBean.getR().length; x++) {
            for (int y = 0; y < shortImageBean.getR()[0].length; y++) {
                if (shortImageBean.getR()[x][y] == 0) continue;
                drawHoughLine(x, y, houghBins);
            }
        }

        //
        //short[][] r = hough(img);
        shortImageBean.setR(houghBins);
        ib.setImageWidth(shortImageBean.getR().length);
        ib.setImageHeight(shortImageBean.getR()[0].length);
        //setSize(getImageWidth(), getImageHeight());
        shortImageBean.copyRedToGreenAndBlue();
        img = ImageUtils.getTransposedImage(houghBins);
        return (img);

    }

}

