/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public class SwapRedGreenFilter extends RgbFilterProcessor {
    public SwapRedGreenFilter() {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        return (
                (rgb & 0xff0000ff)
                |
                ((rgb & 0xff0000) >> 8)
                | ((rgb & 0xff00) << 8));
    }
}
