/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;



/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public class SwapRedBlueFilter extends RgbFilterProcessor {
    public SwapRedBlueFilter() {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        return (
                (rgb & 0xff00ff00)
                |
                ((rgb & 0xff0000) >> 16)
                | ((rgb & 0xff) << 16));
    }
}
